import config from '@/config';
const opapiHost = config.opapiHost;
const ApiBaseUrl = opapiHost + '/ex';
const Mock = require('mockjs');

var billData = Mock.mock({
  data: {
    'detail|1-10': [
      {
        loanId: '@natural(1, 800)',
        planId: '@natural(1, 100)',
        userId: '@natural(1, 200)',
        fundId: '@natural(1, 800)',
        termNo: '@natural(1, 20)',
        'repayStatus|1': [1, 0],
        overdueDays: '@natural(1, 200)',
        deadline: '@datetime',
        repaidAt: '@datetime',
        requiredRepayment: '@natural(1, 800)',
        currentRequiredRepayment: ' @natural(1, 100)',
        actualRepayment: '@natural(1, 200)',
        principal: '@natural(1, 800)',
        interest: '@natural(1, 800)',
        overdueInterest: '@natural(1, 800)',
        serviceFee: ' @natural(1, 100)',
        otherFee: '@natural(1, 200)',
        collectionRelief: '@natural(1, 800)',
        'auditStatus|1': [0, 1, 2],
        offlineRepaySupport: '@boolean',
        'operateRecord|1-20': [
          {
            operateNo: '@email()',
            operateName: '@cname',
            'content|1': ['审批通过', '提交申请', '审批拒绝'],
            operateAt: '@datetime',
            remark: '@ctitle',
          },
        ],
        'ext|1-3': ['@image(100x100)'],
        auditNo: '@natural(4787348374837843, 47873483748378430)',
        tradeFlowNo: '@natural(2787348374837843, 37873483748378430)',
        remark: '@ctitle',
      },
    ],
    hasLoan: '@boolean',
  },
  msg: 'success',
  code: '0000',
  bussinessCode: '0000',
  succsee: true,
});
Mock.mock(RegExp(ApiBaseUrl + '/offline_repay/plans.*'), 'get', billData);
