import config from '../../config';
const { appApi } = config;
import qs from 'qs';
export default {
  // 活动专题列表--检索
  uniqueActivityList(params) {
    return http.get(`${appApi}/api/kdsp/activity/activity-goods/special/list-ge-now?${qs.stringify(params)}`);
  },
  // 上下线
  lineStatus(params) {
    return http.post(`${appApi}/api/kdsp/activity/activity-info/update`, params);
  },
  // 活动名称列表
  activityNameList(params) {
    return http.get(`${appApi}/api/kdsp/activity/activity-info/list-ge-now?${qs.stringify(params)}`);
  },

  // 活动列表-分页
  activityList(params) {
    return http.post(`${appApi}/api/kdsp/activity/activity-info/list-page`, params);
  },
  // 模板管理-商品品类满减-列表
  reductionList(params) {
    return http.get(`${appApi}/api/kdsp/activity/activity-template/list-ge-now?${qs.stringify(params)}`);
  },

  // 活动管理-列表-新增
  newActivity(params) {
    return http.post(`${appApi}/api/kdsp/activity/activity-info/add`, params);
  },
  // 活动管理-列表-修改
  updateActivity(params) {
    return http.post(`${appApi}/api/kdsp/activity/activity-info/update`, params);
  },
  // 活动管理-列表-单个查询,反显数据使用
  getINfo(params) {
    return http.post(`${appApi}/api/kdsp/activity/activity-info/get`, params);
  },
  createPost(params) {
    return http.post(`${appApi}/api/kdsp/activity/activity-info/makePlayBillPicUrl`, qs.stringify(params));
  },
  downloadPost(params) {
    return http.post(`${appApi}/api/kdsp/activity/activity-info/getPlayBillPicUrl`, qs.stringify(params));
  },
  search(params) {
    return http.get(`${appApi}/api/kdsp/op/group-order/list?${qs.stringify(params)}`);
  },
  getGroupCntList() {
    return http.get(`${appApi}/api/kdsp/op/group-cnt/list`);
  },
};
