// The Vue build version to load with the `import` command
// (runtime-only or standalone) has been set in webpack.base.conf with an alias.
import './public-path';
import 'qiniu-js';
import Vue from 'vue';
import store from './vuex/store';
import App from './App';
import routes from './router';
import iView from 'iview';
import Raven from 'raven-js';
import RavenVue from 'raven-js/plugins/vue';
import VueRouter from 'vue-router';
import config from './config';
import { release } from '../.sentryclirc.js';
import VueDND from 'awe-dnd';

if (process.env.SENTRY_ENV !== 'test' && process.env.NODE_ENV === 'production') {
  Raven.config('//dd42a22b816a4ef18521487202048591@sentry.q-gp.com/28', {
    release,
    environment: 'production',
  })
    .addPlugin(RavenVue, Vue)
    .install();
}

Vue.use(iView);
// 注册-拖拽组件
Vue.use(VueDND);

Vue.config.productionTip = false;

/* eslint-disable no-new */

let instance = null;
let router = null;
let timer = null;

export async function bootstrap() {}

export async function mount({ data = {}, http, Cookies, Bus, localStorage } = {}) {
  if (!window.__POWERED_BY_QIANKUN__) {
    ({ http, localStorage, Cookies, Bus } = require('@qg/sys-sdk'));
    http._extend({
      loginUrl: `${config.opUrl}/access/login`, // token过期后的登录地址
      notice: iView.Notice, // 发生错误时提示信息的组件
      refresTokenHost: `http://backstms.q-gp.com`, // 刷新tokenhost
    });
  }

  window.http = http;
  window.LocalStorage = localStorage;
  window.Cookies = Cookies;
  window.Bus = Bus;

  // 兼容子应用不同的解析规则
  http._extend({ dataParseMode: 'default' });

  router = new VueRouter({
    base: window.__POWERED_BY_QIANKUN__ ? '/micro/new-op-optimized-ui' : '/',
    mode: 'history',
    routes,
  });

  router.beforeEach(async (to, from, next) => {
    if (to.path !== '/access/login' && !localStorage.get('token')) {
      let { href } = window.location;
      const { origin } = window.location;
      const opRedirectUrl = `${origin}/access/login`;
      href = href.replace(/\?token=[a-z0-9\-A-Z]+/g, '');
      window.location.href = opRedirectUrl + '?url=' + window.btoa(href);
      return;
    }

    next();
  });

  timer = setTimeout(() => {
    instance = new Vue({
      el: '#app',
      router,
      store, // 使用store
      render(h) {
        return h(App, {
          props: {
            store: data,
          },
        });
      },
    });
  });
}

export async function unmount() {
  if (timer) clearTimeout(timer);
  console.log('$destroy', instance, instance && instance.$destroy);
  if (instance) instance.$destroy();
  timer = null;
  instance = null;
  router = null;
}

// 单独开发环境
window.__POWERED_BY_QIANKUN__ || mount();
