/**
 * Created by sunxiaoying on 2017/10/14.
 */
import qs from 'qs';
import config from '../../config';
import fileSaver from 'file-saver';
const { baseURI: apiBaseUrls, smsApiBaseUrls, moConfigApi, appApi } = config;
export default {
  getTemplatePage(params) {
    return http.post(`${smsApiBaseUrls}/middle_office/template/page`, params);
  },
  getTemplateInfo(id) {
    return http.get(`${smsApiBaseUrls}/middle_office/template/${id}`);
  },
  templateEnable(id, enable) {
    return http.delete(`${smsApiBaseUrls}/middle_office/template/${id}/${enable}?author=test&authorName=test`);
  },
  updateTemplate(params) {
    return http.post(`${smsApiBaseUrls}/middle_office/template`, params);
  },
  template() {
    return http.get(`${smsApiBaseUrls}/middle_office/select/templateType`);
  },
  channelType() {
    return http.get(`${smsApiBaseUrls}/middle_office/select/channelType`);
  },
  msgType() {
    return http.get(`${smsApiBaseUrls}/middle_office/select/msgType`);
  },
  getParamsList(templateType) {
    return http.get(`${smsApiBaseUrls}/middle_office/select/fields?templateType=${templateType}`);
  },
  getPlatformType() {
    return http.get(`${smsApiBaseUrls}/middle_office/select/smsMarketPlatformType`); // 获取通道下拉列表
  },
  templateType(templateType) {
    return http.get(`${smsApiBaseUrls}/middle_office/template/list/${templateType}`);
  },
  sign(platform) {
    return http.get(`${smsApiBaseUrls}/middle_office/sign_market/${platform}`);
  },
  addSignature(params) {
    return http.post(`${smsApiBaseUrls}/middle_office/sign_market?author=test&authorName=test`, params);
  },
  getChannelList() {
    return http.get(`${apiBaseUrls}/message/query-send-channel`);
  },
  send(params) {
    const form = new FormData();
    for (const key in params) {
      form.append(key, params[key]);
    }
    return http.post(`${apiBaseUrls}/message/send`, form);
  },
  down() {
    window.location.href = `${apiBaseUrls}/template.xlsx`;
  },
  messageType() {
    return http.get(`${apiBaseUrls}/message/batch/messagetype`);
  },
  querySendList(params) {
    return http.post(`${apiBaseUrls}/message/batch/list/${params.page}/${params.size}`, params);
  },
  updateCtr() {
    return http.post(`${apiBaseUrls}/message/batch/update-ctr`);
  },
  downFile(id, sendTime) {
    return http
      .get(`${apiBaseUrls}/message/batch/download/${id}`, {
        responseType: 'arraybuffer',
      })
      .then(data => {
        if (data.byteLength > 0) {
          const blob = new Blob([data], { type: 'application/vnd.ms-excel;' });
          fileSaver.saveAs(blob, `${sendTime}.xlsx`);
        }
      });
  },
  getNodeInfo(id) {
    return http.get(`${moConfigApi}/msg/fund_channel_node/${id}`);
  },
  updateNodeStatus({ id, enable }) {
    return http.delete(`${moConfigApi}/msg/fund_channel_node/${id}?enable=${enable}`);
  },
  saveNode(params) {
    return http.post(`${moConfigApi}/msg/fund_channel_node`, params);
  },
  queryNode(params) {
    return http.get(`${moConfigApi}/msg/fund_channel_node/page?${qs.stringify(params)}`);
  },
  getNodeStatus() {
    return http.get(`${moConfigApi}/select/fund_channel_node_type`);
  },
  getBlackInfo(id) {
    return http.get(`${smsApiBaseUrls}/middle_office/sms_market_black_list/${id}`);
  },
  updateBlackStatus({ id, enable, description }) {
    return http.delete(`${smsApiBaseUrls}/middle_office/sms_market_black_list/${id}/${enable}?description=${description}`);
  },
  saveBlack(params) {
    return http.post(`${smsApiBaseUrls}/middle_office/sms_market_black_list`, params);
  },
  queryBlackList(params) {
    return http.post(`${smsApiBaseUrls}/middle_office/sms_market_black_list/page`, params);
  },
  getSmsPlatformType() {
    return http.get(`${smsApiBaseUrls}/middle_office/select/smsPlatformType`);
  },
  // 转换短链接
  uploadShortUrl(file) {
    const params = new FormData();
    params.append('file', file);
    return http.post(`${appApi}/api/kdsp/shortUrl/upload_short_url`, params);
  },

  // 下载模板
  templateDown() {
    return http
      .post(`${appApi}/api/kdsp/shortUrl/example_download`, null, {
        responseType: 'arraybuffer',
      })
      .then(data => {
        if (data.byteLength > 0) {
          const blob = new Blob([data], { type: 'application/vnd.ms-excel;' });
          fileSaver.saveAs(blob, `长链接转短链接上传模板.xls`);
        }
      });
  },

  // 查询状态
  checkStatus() {
    return http.get(`${appApi}/api/kdsp/shortUrl/check_status`);
  },

  // 下载
  relaDown() {
    return http.get(`${appApi}/api/kdsp/shortUrl/real_download`);
  },
};
