import qs from 'qs';
import config from '../../config';

const { appApi } = config;
// appApi = 'https://opapi-vcc3.liangkebang.net/kdspOp'
export default {
  // 查询商品标签列表
  getLabelList() {
    return http.get(`${appApi}/api/kdsp/op/ka/label/querylist`);
  },
  // 查询优惠券批次列表
  getCouponList(params) {
    return http.post(`${appApi}/api/kdsp/op/coupon/list`, params);
  },
  // 检查渠道编码
  checkChannel(params) {
    return http.get(`${appApi}/api/kdsp/op/ka-depoy/check_channel?${qs.stringify(params)}`);
  },
  // 新增配置
  addInfo(params) {
    return http.get(`${appApi}/api/kdsp/op/ka-depoy/add_info?${qs.stringify(params)}`);
  },
  editInfo(params) {
    return http.get(`${appApi}/api/kdsp/op/ka-depoy/update_info?${qs.stringify(params)}`);
  },
  // 列表页
  getKAList(params) {
    return http.get(`${appApi}/api/kdsp/op/ka-depoy/queryList?${qs.stringify(params)}`);
  },
  // 查询配置信息
  getInfo(params) {
    return http.get(`${appApi}/api/kdsp/op/ka-depoy/queryInfo?${qs.stringify(params)}`);
  },
  // 发布||下线
  changeStatus(params) {
    return http.get(`${appApi}/api/kdsp/op/ka-depoy/update_status?${qs.stringify(params)}`);
  },
};
