const POINT_TYPE = [
  {
    id: 'ONVALID',
    name: '停用',
  },
  {
    id: 'VALID',
    name: '启用',
  },
];
const LEVEL_LIST = [
  {
    id: 1,
    value: 1,
  },
  {
    id: 2,
    value: 2,
  },
  {
    id: 3,
    value: 3,
  },
  {
    id: 4,
    value: 4,
  },
  {
    id: 5,
    value: 5,
  },
  {
    id: 6,
    value: 6,
  },
];
const BUS_LIST = [
  {
    id: 1,
    name: '电商业务',
  },
  {
    id: 2,
    name: '支付业务',
  },
];
const GET_AND_USE = [
  {
    id: 1,
    name: '商品类目',
  },
  {
    id: 2,
    name: '活动',
  },
];
const GET_TYPE_LIST = [
  {
    id: 1,
    name: '主动领取',
  },
  {
    id: 2,
    name: '自动发放',
  },
  {
    id: 3,
    name: '不限',
  },
];
const USE_SCENCE = [
  {
    id: 1,
    name: '指定品类',
    businessType: 1,
  },
  {
    id: 2,
    name: '指定标签',
    businessType: 1,
  },
  {
    id: 21,
    name: '享花卡支付',
    businessType: 2,
  },
];
const RULE_VALONE = {
  imageUrl: [
    {
      required: true,
      message: '请选择图片',
      trigger: 'change',
      type: 'array',
      // validator: imgCheck,
    },
  ],
  taskType: [
    {
      required: true,
      message: '请选择任务类型',
      trigger: 'change',
    },
  ],
  nodeNo: [
    {
      required: true,
      message: '请选择完成节点',
      trigger: 'change',
    },
  ],
  name: [
    {
      required: true,
      message: '请输入任务名称',
      trigger: 'blur',
    },
  ],
  frequency: [
    {
      required: true,
      message: '请输入积分限制',
      trigger: 'blur',
    },
  ],
  taskUrl: [
    {
      required: true,
      message: '请输入URL',
      trigger: 'blur',
    },
  ],
  eventPoint: [
    {
      required: true,
      message: '请输入积分规则',
      trigger: 'blur',
    },
  ],
  enable: [
    {
      required: true,
      message: '请选择是否生效',
      trigger: 'blur',
    },
  ],
};
// const TASKTYPE_LIST = [
//   {
//     id: 1,
//     name: '新手任务',
//   },
//   {
//     id: 2,
//     name: '日常任务',
//   },
//   {
//     id: 3,
//     name: '亲密任务',
//   },
// ];
// 列表展示状态
const LIST_STATUS = [
  {
    id: 'WAIT_ON_LINE',
    name: '待发布',
  },
  {
    id: 'ON_LINE',
    name: '已上架',
  },
  {
    id: 'OFF_LINE',
    name: '已下架',
  },
];
// 终端数组：1：app,2:h5,3:公众号4：小程序 ，5：通用
const TERMIANL_LIST = [
  {
    id: 1,
    name: 'app',
  },
  {
    id: 2,
    name: 'H5',
  },
  {
    id: 3,
    name: '公众号',
  },
  {
    id: 4,
    name: '小程序',
  },
  {
    id: 5,
    name: '通用',
  },
];
//
const STATUS_LIST = [
  {
    id: 1,
    name: '待发布',
  },
  {
    id: 2,
    name: '已上架',
  },
  {
    id: 3,
    name: '已下架',
  },
  {
    id: 4,
    name: '已过期',
  },
];
const PUSH_LIST = [
  {
    id: 1,
    name: '线上',
  },
  // {
  //   id: 2,
  //   name: '线下',
  // },
];
const INCOME_LIST = [
  {
    id: 1,
    name: '收入',
  },
  {
    id: -1,
    name: '支出',
  },
];
// 优惠券类型
const COUPON_LIST = [
  {
    id: 1,
    name: '满减券',
    businessType: 1,
  },
  {
    id: 2,
    name: '运费券',
    businessType: 1,
  },
  {
    id: 3,
    name: '现金券',
    businessType: 1,
  },
  // {
  //   id: 4,
  //   name: '现金券',
  //   businessType: 1,
  // },
  {
    id: 21,
    name: '享花券',
    businessType: 2,
  },
];
// 优惠券状态
const HASUSED_LIST = [
  {
    id: 1,
    name: '未使用',
  },
  {
    id: 2,
    name: '已使用',
  },
  {
    id: 3,
    name: '已过期',
  },
];
// 邀请好友列表展示
const FRIEND_COLUMNS = [
  {
    title: '序号',
    key: 'id',
    align: 'center',
  },
  {
    title: '邀请人',
    key: 'userId',
    align: 'center',
  },
  {
    title: '被邀请人',
    key: 'invitee',
    align: 'center',
  },
  {
    title: '注册时间',
    key: 'createdAt',
    align: 'center',
  },
];
// 商品信息展示
const GOODINFO_COLUMNS = [
  {
    title: '商品编号',
    key: 'skuName',
    align: 'center',
  },
  {
    title: '商品分类',
    key: 'categoryNames',
    align: 'center',
  },
  {
    title: '商品名称',
    key: 'skuName',
    align: 'center',
  },
];
// 积分明查询列表展示
export const POINT_COULMNS = function() {
  return [
    {
      title: '序号',
      key: 'id',
      align: 'center',
      width: '100px',
    },
    {
      title: '用户userId',
      key: 'userId',
      align: 'center',
    },
    {
      title: '积分变动',
      key: 'eventPoint',
      align: 'center',
      render: (h, params) => {
        const eventPoint = params.row.eventPoint > 0 ? '+' + params.row.eventPoint : params.row.eventPoint;
        return h('div', eventPoint);
      },
    },
    {
      title: '收支类型',
      key: 'becomeType',
      align: 'center',
      render: (h, params) => {
        const incomeName = params.row.eventPoint > 0 ? '收入' : '支出';
        return h('div', incomeName);
      },
    },
    {
      title: '积分类型',
      key: 'eventType',
      align: 'center',
      render: (h, params) => {
        const obj = this.eventTypeList.find(item => item.id === params.row.eventType) || {};
        return h('div', obj.value);
      },
    },
    {
      title: '积分任务名称',
      key: 'alisaName',
      align: 'center',
    },
    {
      title: '操作时间',
      key: 'createdAt',
      align: 'center',
      // render: (h, params) => {
      //   const effectiveTime = `${params.row.createdAt} - ${params.row.updatedAt}`;
      //   return h('div', effectiveTime);
      // },
    },
  ];
};
// APP_ANDROID(217, "Android", "安卓"),
// APP_IOS(214, "IOS", "苹果"),
// H5(null, "H5", "H5"),
// MINI(null, "MINI-APP", "小程序"),
// GZH(null, "OFFICIAL-ACCOUNT", "公众号"),
// ALL(null, "ALL", "全平台"),

// 领取/使用-终端
const TERMINAL_LIST = [
  {
    id: 'ANDROID',
    name: 'Android',
  },
  {
    id: 'IOS',
    name: 'IOS',
  },
  {
    id: 'H5',
    name: 'H5',
  },
  {
    id: 'MINI-APP',
    name: '小程序',
  },
  {
    id: 'OFFICIAL-ACCOUNT',
    name: '公众号',
  },
  {
    id: 'ALL',
    name: '全平台',
  },
];
const RECEIVER_LIST = [
  {
    id: 1,
    name: '主动领取',
  },
  {
    id: 2,
    name: '自动发放',
  },
  {
    id: 3,
    name: '不限',
  },
];
const RULE_AUTO = {
  userIds: [
    {
      required: true,
      message: '请输入userIds',
      trigger: 'blur',
    },
  ],
  receiverNum: [
    {
      required: true,
      message: '请输入正确的发行张数',
      trigger: 'blur',
      type: 'number',
    },
  ],
};
// 发行记录页面新建表单校验
const RULE_VAL = {
  businessType: [
    {
      required: true,
      message: '请选择业务类别',
      trigger: 'change',
    },
  ],
  receiverType: [
    {
      required: true,
      message: '请选择领取方式',
      trigger: 'change',
    },
  ],
  pushType: [
    {
      required: true,
      message: '请选择发行方式',
      trigger: 'change',
    },
  ],
  couponType: [
    {
      required: true,
      message: '请选择优惠券类型',
      trigger: 'change',
    },
  ],
  applyReason: [
    {
      required: true,
      message: '请输入申请原因',
      trigger: 'blur',
    },
  ],
  receiverLimitCount: [
    {
      required: true,
      message: '请输入限制数量',
      trigger: 'blur',
      pattern: /^\+?[1-9]\d*$/,
    },
  ],
  name: [
    {
      required: true,
      message: '请输入优惠券名称',
      trigger: 'blur',
    },
  ],
  receiverLimitType: [
    {
      required: true,
      message: '请选择领取限制',
    },
  ],
  opTerminalTypes: [
    {
      required: true,
      type: 'array',
      message: '请选择终端',
    },
  ],
  usedLimitLabelIds: [
    {
      required: true,
      type: 'array',
      message: '请选择标签id',
    },
  ],
  selectReceiverLabelIdList: [
    {
      required: true,
      type: 'array',
      message: '请选择商品标签',
    },
  ],
  receiverLimitScopeReq: [
    {
      required: true,
      message: '请选择领取场景',
      trigger: 'change',
    },
  ],
  usedLimitScopeReq: [
    {
      required: true,
      message: '请选择使用场景',
      trigger: 'change',
    },
  ],
  couponDesc: [
    {
      required: true,
      message: '请输入优惠券说明',
      trigger: 'blur',
    },
  ],
  limitAmt: [
    {
      required: true,
      message: '请输入正确的满减券属性',
      trigger: 'blur',
      // 包含0的正数
      // pattern: /^[+]{0,1}(\d+)$/,
      pattern: /^\d+(\.\d{1,2})?$/,
      // 正整数
      // pattern: /^[0-9]*[1-9][0-9]*$/,
    },
  ],
  couponAmt: [
    {
      required: true,
      message: '请输入券面值',
      trigger: 'blur',
      // 大于0的正数
      // pattern: /^\+?[1-9]\d*$/,
      pattern: /^0\.([1-9]|\d[1-9])$|^[1-9]\d{0,8}\.\d{0,2}$|^[1-9]\d{0,8}$/,
      // 正整数
      // pattern: /^[0-9]*[1-9][0-9]*$/,
    },
  ],
  receiverDaysValid: [
    {
      required: true,
      message: '请输入正确的领取时间',
      trigger: 'blur',
      pattern: /^[+]{0,1}(\d+)$/,
    },
  ],
  validDays: [
    {
      required: true,
      message: '请输入正确的有效天数',
      trigger: 'blur',
      //  包含0的 正整数
      pattern: /^[+]{0,1}(\d+)$/,
    },
  ],
  validHours: [
    {
      required: true,
      message: '请输入正确的有效时间',
      trigger: 'blur',
      //  包含0的 正整数
      pattern: /^[+]{0,1}(\d+)$/,
    },
  ],
  useTimeStart: [
    {
      required: true,
      message: '请输入开始日期',
      trigger: 'change',
    },
  ],
  useTimeEnd: [
    {
      required: true,
      message: '请输入结束日期',
      trigger: 'change',
    },
  ],
  validTimesType: [
    {
      required: true,
      message: '请选择使用有效期',
    },
  ],
  usedMutex: [
    {
      required: true,
      message: '请选择是否与满减券互斥',
    },
  ],
  pushCount: [
    {
      required: true,
      message: '请输入大于0的发行数量',
      trigger: 'blur',
      pattern: /^\+?[1-9]\d*$/,
    },
  ],
};
//  terminalGzh:公众号-3
//  terminalMini：小程序-4
// terminalH5：H5-1
// terminalApp:App-1
// terminalAll:通用-5
const KEY_ARRAY = ['terminalApp', 'terminalH5', 'terminalGzh', 'terminalMini', 'terminalAll'];
const RECORD_COLUMNS = [
  {
    type: 'selection',
    width: 60,
    align: 'center',
  },
  {
    title: '批次id',
    key: 'couponUser.couponInfoId',
    align: 'center',
    render: (h, params) => {
      const couponInfoId = params.row.couponUser.couponInfoId;
      return h('div', couponInfoId);
    },
  },
  {
    title: '优惠券id',
    key: 'couponUser.userid',
    align: 'center',
    render: (h, params) => {
      const id = params.row.couponUser.id;
      return h('div', id);
    },
  },

  {
    title: '优惠券名称',
    key: 'couponInfo.name',
    align: 'center',
    render: (h, params) => {
      const name = params.row.couponInfo.name;
      return h('div', name);
    },
  },
  {
    title: '优惠券类型',
    key: 'couponInfo.couponType',
    align: 'center',
    render: (h, params) => {
      const obj = COUPON_LIST.find(item => item.id === params.row.couponInfo.couponType) || {};
      if (params.row.couponInfo.couponType === 3 || params.row.couponInfo.couponType === 4) {
        if (params.row.couponInfo.couponAmt !== 0) {
          return h('div', '现金券(固定)');
        } else {
          return h('div', '现金券(浮动)');
        }
      }
      return h('div', obj.name);
    },
  },
  {
    title: '优惠券状态',
    key: 'couponUser.hasUsed',
    align: 'center',
    render: (h, params) => {
      const obj = HASUSED_LIST.find(item => item.id === params.row.couponUser.hasUsed) || {};
      return h('div', obj.name);
    },
  },
  {
    title: '用户id',
    key: 'couponUser.userId',
    align: 'center',
    render: (h, params) => {
      const userId = params.row.couponUser.userId;
      return h('div', userId);
    },
  },
  {
    title: '领取终端',
    key: 'couponUser.receiverTerminal',
    align: 'center',
    render: (h, params) => {
      const obj = TERMINAL_LIST.find(item => item.id === params.row.couponUser.receiverTerminal) || {};
      return h('div', obj.name);
    },
  },
  {
    title: '领取时间',
    key: 'couponUser.receiverTime',
    align: 'center',
    render: (h, params) => {
      const receiverTime = params.row.couponUser.receiverTime;
      return h('div', receiverTime);
    },
  },
  {
    title: '有效日期',
    key: 'couponUser',
    align: 'center',
    render: (h, params) => {
      const startingTime = params.row.couponUser.useStartTime + '-' + params.row.couponUser.useEndTime;
      return h('div', startingTime);
    },
  },

  {
    title: '使用时间',
    key: 'couponUser.usedTime',
    align: 'center',
    render: (h, params) => {
      const usedTime = params.row.couponUser.usedTime;
      return h('div', usedTime);
    },
  },
  {
    title: '使用终端',
    key: 'couponUser.usedTerminal',
    align: 'center',
    render: (h, params) => {
      const obj = TERMINAL_LIST.find(item => item.id === params.row.couponUser.usedTerminal) || {};
      return h('div', obj.name);
    },
  },
];
export default {
  POINT_TYPE,
  LEVEL_LIST,
  POINT_COULMNS,
  RECORD_COLUMNS,
  KEY_ARRAY,
  BUS_LIST,
  STATUS_LIST,
  LIST_STATUS,
  FRIEND_COLUMNS,
  GOODINFO_COLUMNS,
  // TASKTYPE_LIST,
  TERMIANL_LIST,
  RECEIVER_LIST,
  HASUSED_LIST,
  GET_AND_USE,
  PUSH_LIST,
  COUPON_LIST,
  TERMINAL_LIST,
  RULE_VAL,
  RULE_VALONE,
  INCOME_LIST,
  GET_TYPE_LIST,
  USE_SCENCE,
  RULE_AUTO,
};
