import config from '../../config/index.js';
const { baseURI: ApiBaseUrl, moConfigApi } = config;
export default {
  query(params) {
    return http.post(`${ApiBaseUrl}/config/strategy/query`, params);
  },
  saveStrategy(params) {
    return http.post(`${ApiBaseUrl}/config/strategy/modify`, params);
  },
  getUserState() {
    return http.get(`${ApiBaseUrl}/config/strategy/query-user-state`);
  },
  getUserTemplateIds(id) {
    return http.get(`${ApiBaseUrl}/config/strategy/get-template_ids/${id}`);
  },
  getChannel(idPrefix) {
    return http.get(`${moConfigApi}/select/channel/${idPrefix}`, {
      headers: {
        _isLoading: false,
      },
    });
  },
};
