## 介绍

中间件使用了agentkeepalive，通过复用socket来减少资源占用，加快代理响应速度。

## 发布方式
```
npm publish --registry http://172.16.3.15:4873
```

## 快速起步
```
const Router = require('koa-router');
const router = new Router();
const proxy = require('request-proxy');
const demo = require('./controller/demo')

router
  .use(proxy())
  .use('/demo', demo.routes())
```

```
// demo.js
const pipe = async function (ctx) {
  await ctx.pipe('http://localhost:7054' + ctx.url.replace('/test/1', '/upload/test/1'))
  // no more code ...
}

const curl = async function (ctx) {
  let result = await ctx.curl('http://localhost:7054' + ctx.url.replace('/test/1', '/upload/test/1'))
  ctx.status = result.status
  ctx.body = result.body
}

const router = new Router();
router
  .get('/curl/*', curl)
  .get('/pipe/*', pipe)

module.exports = router

```

## 注意事项

### 参数问题
```
pipe

option: 对象格式，和request包参数一直
    如果是字符串类型，默认会转为{uri: 'some string'}

extra: 对象格式，现有两个属性
    rawRes: 是否返回接受到的res,默认false
    throw: 请求错误的时候是否抛出，中间件会自动捕获，默认true

```

### 如何在bodyParse后透传post请求
```
// 由于bodyParse会读取request流中的body信息，所有透传的时候就会丢失
// 解决方法：使用curl方式，手动将body参数上

if (ctx.method === 'POST') {
    let option = {
      uri: config.api.mall_api + ctx.url.replace('/mall/other', ''),
      headers: {
        'x-auth-token': ctx.headers['x-auth-token']
      }
    }

    if (ctx.is('json')) {
      option.body = ctx.request.body
    } else if (ctx.is('urlencoded')) {
      option.form = ctx.request.body
    }

    let result = await ctx.curl(option)
    ctx.status = result.status
    ctx.body = result.body
    return
  }
```

### 如何返回headers
```
ctx.set(result.headers)

或者

ctx.res._headers = {'x-auth-token': '123'}
```
