import Vue from 'vue';
import Router from 'vue-router';

const home = r => require.ensure([], () => r(require('@/components/home.vue')), 'home');
const login = r => require.ensure([], () => r(require('@/components/login.vue')), 'login');

Vue.use(Router);

export default new Router({
  mode: 'history',
  routes: [
    {
      path: '/',
      redirect: '/home',
    }, {
      path: '/login',
      name: 'login',
      component: login,
    }, {
      path: '/home',
      name: 'home',
      component: home,
      children: [
        {
          path: '/user/login',
          name: 'userLogin',
          component: login
        }
      ]
    },
  ],
});
