import Vue from 'vue';
import Router from 'vue-router';

const home = r => require.ensure([], () => r(require('@/components/home.vue')), 'home');
// const changepsd = r => require.ensure([], () => r(require('@/components/changepsd.vue')), 'changepsd');
const login = r => require.ensure([], () => r(require('@/page/login/login.vue')), 'login');
const update = r => require.ensure([], () => r(require('@/page/login/update.vue')), 'update');
const resumeDetail = r =>require.ensure([], () => r(require('@/page/resume/resumeDetail.vue')),'resumeDetail')
const pdfdetail = r =>require.ensure([], () => r(require('@/page/resume/pdfdetail.vue')),'pdfdetail')
const interview = r => require.ensure([], () => r(require('@/page/interview/interview.vue')), 'interview');
const allResume = r => require.ensure([], () => r(require('@/page/resume/allResume.vue')), 'allResume');
const channel = r => require.ensure([], () => r(require('@/page/resume/channel.vue')), 'channel');
const account = r => require.ensure([], () => r(require('@/page/system/account.vue')), 'account');
const emailMange = r => require.ensure([], () => r(require('@/page/system/emailMange.vue')), 'emailMange');
const QRcode = r => require.ensure([], () => r(require('@/page/system/QRcode.vue')), 'QRcode');
const upload = r => require.ensure([], () => r(require('@/page/upload/upload.vue')), 'upload');
const sweepCode = r => require.ensure([], () => r(require('@/page/sweepCode/sweepCode.vue')), 'sweepCode');
const editor = r => require.ensure([], () => r(require('@/components/editor.vue')), 'editor');
const getimage = r => require.ensure([], () => r(require('@/components/getimage.vue')), 'getimage');

//z注释

Vue.use(Router);

export default new Router({
  mode: 'history',
  routes: [
    {
      path: '/',
      redirect: '/home',
    }, {
      path: '/login',
      name: 'login',
      component: login,
      meta: {
        allowBack: false
      }
    },
     {
      path:'/sweepCode',
      name:'sweepCode',
      component:sweepCode
    },
    {
      path:'/update',
      name:'update',
      component:update
    },
    {
      path:'/getimage',
      name:'getimage',
      component:getimage
    },
    {
      path: '/resumeDetail',
      name: 'resumeDetail',
      component: resumeDetail
    },{
      path: '/pdfdetail',
      name: 'pdfdetail',
      component: pdfdetail
    },
    {
      path: '/editor',
      name: 'editor',
      component: editor
    },
    {
      path: '/home',
      name: 'home',
      component: home,
      children: [
        {
          path: '/interview',
          name: 'interview',
          component: interview
        },
        {
          path: '/allResume',
          name: 'allResume',
          component: allResume
        },
        {
          path: '/channel/:channelname',
          name: 'channel',
          component: channel
        },
        {
          path: '/account',
          name: 'account',
          component: account
        },
        {
          path: '/emailMange',
          name: 'emailMange',
          component: emailMange
        },
        {
          path: '/QRcode',
          name: 'QRcode',
          component: QRcode
        },
        {
          path: '/upload',
          name: 'upload',
          component: upload
        }
      ]
    },
  ],
});
