import axios from 'axios'
import Promise from './promise.service.js'
import {Notice} from 'iview'
import Vue from 'vue'
var instance = axios.create({});
instance.defaults.timeout = 2500;


// instance.defaults.headers.common['Authorization'] = AUTH_TOKEN;
instance.defaults.headers.post['Content-Type'] = 'application/x-www-form-urlencoded';
instance.defaults.headers['X-Requested-With'] = 'XMLHttpRequest'
instance.defaults.headers['X-auth-Token'] = 'XMLHttpRequest'

instance.interceptors.request.use(function (config) {
    // 在发送请求之前做些什么
    if (!config.headers['Content-Type']) {
      config.headers['Content-Type'] = 'application/x-www-form-urlencoded'
    }
    config.withCredentials = true;
    return config;
  }, function (error) {
    // 对请求错误做些什么
    return Promise.reject(error);
  });
instance.interceptors.response.use(function (response) {
    // 在发送请求之前做些什么
    
    if(response.status >= 200 && response.status < 300){
      if (response.data.body.code == '900'){
        console.log(666666666666)
        Notice.error('您的账号已在其他地方登录，如不是您个人操作，请及时修改密码')
        window.location.href = `${window.location.origin}/login`
      }
      if(response.data.success){
        return Promise.resolve(response)
      } 
      
      else {
        if (response.data.body.message){
          // Notice.error({desc:`${response.data.body.message}`})
        }
        return Promise.resolve(response);
      }
    } else {
      // return Promise.resolve(response);
    }
    return response;
  }, error => {
    // Notice.error({desc:`${error.response.data.body.message}`})
  });
export default instance
// export default axios
