import axios from '../service/http.service'
import {
    baseApi,contractApi
} from '../config/env.config'
import qs from 'qs'
// 查询简历列表
export function serchList(parmars){
    return axios.post(`/text/api/resume/findList`,parmars,{headers: {
        'Content-Type':'application/json'
    }})
}
// 下载简历（单条）
export function downloadone (parmars) {
    parmars=qs.stringify(parmars)
    return axios.post(`/text/api/resumeFile/download/formatted/one`,parmars,{headers: {
        'Content-Type':'application/x-www-form-urlencoded'
    }})
}
// 搜索
export function sousuoList (parmars) {
    return axios.post(`/text/api/resume/findListByQueryVO`,parmars,{headers: {
        'Content-Type':'application/json',
        'X-Requested-With':'XMLHttpRequest'
    }})
}
//查看简历详情页
export function seedetail (parmars) {
    return axios.get(`/text/api/html/get/${parmars.resumeId}`,{headers: {
        'Content-Type':'application/json'
    }})
}
// 简历pass
export function PASS (parmars) {
    console.log(parmars)
    return axios.post(`/text/api/resumeFlow/uploadStatus/${parmars.id}/${parmars.status}`,'',{headers: {
        'Content-Type':'application/json'
    }})
}
// 准备约面
export function TOSEE (parmars) {
    return axios.post(`/text/api/resumeFlow/uploadStatus/${parmars.id}/${parmars.status}`,'',{headers: {
        'Content-Type':'application/json'
    }})
}
// 备选
export function OPTION (parmars) {
    return axios.post(`/text/api/resumeFlow/uploadStatus/${parmars.id}/${parmars.status}`,'',{headers: {
        'Content-Type':'application/json'
    }})
}
// 删除简历
export function deleteREsume (deleteallArr) {
    return axios.post(`/text/api/resume/delete`,JSON.stringify(deleteallArr),{headers: {
        'Content-Type':'application/json',
        'X-Requested-With':'XMLHttpRequest'
    }})
}
// 单条下载简历
export function downloadOne (parmars) {
    console.log(parmars.resumeId)
    return axios.get(`/text/api/resume/download/formatted/one?resumeId=${parmars.resumeId}`,{headers: {
        // 'Content-Type':'application/x-www-form-urlencoded'
    }})
}
// 批量下载简历
export function downloadALL () {
    return axios.get(`/text/api/resumeFile/download/formatted/compress`,{headers: {
        'Content-Type':'application/x-www-form-urlencoded'
    }})
}
// 导出列表
export function exportLIST (parmars) {
    return axios.get(`/text/api/excel/output?optSource=${parmars.optSource}&keywordString=${parmars.keywordString}&company=${parmars.company}&ownerSex=${parmars.ownerSex}&highestDegreeNum=${parmars.highestDegreeNum}&flowStatusList=${parmars.flowStatusList}&ownerWorkYears1=${parmars.ownerWorkYears1}&ownerWorkYears2=${parmars.ownerWorkYears2}`,
      {headers: {
        'Content-Type':'application/json'
      }})
}
// 操作记录
export function recodeLIST (parmars) {
    return axios.post(`/text/api/resumeFlow/history/${parmars.resumeId}`,{headers: {
        'Content-Type':'application/json'
    }})
}
//通过某一来源查询简历信息
export function adoptOneSeeResumeList(parmars) {
    return axios.post(`/text/api/resume/findListBySource`,parmars,{headers: {
        'Content-Type':'application/json',
        'X-Requested-With':'XMLHttpRequest'
    }})
}
// 新增约面信息
export function addinterview(parmars) {
    return axios.post(`/text/api/resumeInterview/add`,parmars,{headers: {
        'Content-Type':'application/json',
        'X-Requested-With':'XMLHttpRequest'
    }})
}
// 修改流程状态
export function updatastatus(parmars) {
    return axios.post(`/text/api/resumeFlow/uploadStatus/${parmars.id}/${parmars.status}`,{headers: {
        'Content-Type':'application/json',
        'X-Requested-With':'XMLHttpRequest'
    }})
}