export function _debounce (fn, delay) {
  let timer = null
  delay = delay || 200

  return function () {
    let args = arguments
    

    if (timer) {
      clearTimeout(timer)
    }

    timer = setTimeout(function () {
      timer = null
      console.log(this)
      fn.apply(this, args)
    }.bind(this), delay)
  }
}

export function _throttle (fn, interval) {
  let last = null
  let timer = null
  interval = interval || 200

  return function () {
    let self = this
    let args = arguments
    let now = +new Date()
    if (last && now - last < interval) {
      clearTimeout(timer)
      timer = setTimeout(function () {
        last = now
        fn.apply(self, args)
      }, interval)
    } else {
      last = now
      fn.apply(self, args)
    }
  }
}