export function _debounce (fn, delay) {
  let timer = null
  delay = delay || 200

  return function () {
    let args = arguments

    if (timer) {
      clearTimeout(timer)
    }

    timer = setTimeout(function () {
      timer = null
      fn.apply(this, args)
    }.bind(this), delay)
  }
}

export function _throttle (fn, interval) {
  let last = null
  let timer = null
  interval = interval || 200
  return function () {
    let self = this
    let args = arguments
    let now = +new Date()
    if (last && now - last < interval) {
      clearTimeout(timer)
      timer = setTimeout(function () {
        last = now
        fn.apply(self, args)
      }, interval)
    } else {
      last = now
      fn.apply(self, args)
    }
  }
}
export function emailValidata (rule, value, callback){
              let field = rule.field
              let reg = rule.pattern
              switch(field){
                case 'receiveEmail': 
                  if (!value) {
                    this.tip = true
                    this.isDisable=false
                    callback(new Error('收件人不能为空'))
                  }
                  else if (rule.pattern&&!rule.pattern.test(value)) {
                    this.tip = true
                    this.isDisable=false
                    callback(new Error('请输入正确收件人地址'))
                  }else {
                    this.tip = false
                    this.isDisable=true
                    callback()
                  }
                break;
                case 'theme': 
                  if (!value) {
                    this.isDisable=false
                    callback(new Error('主题能为空'))
                  } else {
                    this.isDisable=true
                    callback()
                  }
                break;
                case 'copyname': 
                  if (value&&reg&&!reg.test(value)) {
                    this.isDisable=false
                    callback(new Error('请输入正确抄送地址'))
                  } else {
                    this.isDisable=true
                    callback()
                  }
                break;
                case 'UpdateOWER': 
                  if (!value) {
                    this.isDisable=false
                    callback(new Error('邀约人不能为空'))
                  } else {
                    this.isDisable=true
                    callback()
                  }
                break;
                case 'UpdateTIME': 
                  if (!value) {
                    this.isDisable=false
                    callback(new Error('面试时间不能为空'))
                  } else {
                    this.isDisable=true
                    callback()
                  }
                break;
                case 'UpdateVIEW': 
                  if (!value) {
                    this.isDisable=false
                    callback(new Error('面试官不能为空'))
                  } else {
                    this.isDisable=true
                    callback()
                  }
                break;
                default: 
                  callback()
                break;
              }
               
            }
export const emailRule = /^((([a-z0-9_\.-]+)@([\da-z\.-]+)\.([a-z\.]{2,6}\;))*(([a-z0-9_\.-]+)@([\da-z\.-]+)\.([a-z\.]{2,6})))$/
export function vidte(rule,value,callback){
                if(this.emailMassage==true){
                    callback(new Error('你尚未选择简历，请先选择简历'))
                }
                else if(this.allEmailVilitor==true){
                  callback(new Error('不能选择多份简历，请选择单份简历'))
                }
                else{
                    callback ()
                }
            }
export function validator (rule, value, callback){
              if (!value)this.$Notice.warning({title: '提示',desc: '请输入您要通知的面试官'})
              callback()
            }