import axios from 'axios'
import Promise from './promise.service.js'
import {Notice} from 'iview'
import Vue from 'vue'
import router from '../router/index.js'
// axios.defaults.withCredentials = true
var instance = axios.create({});
instance.defaults.timeout = 3600000;
instance.defaults.withCredentials = true;

instance.defaults.headers.post['Content-Type'] = 'application/x-www-form-urlencoded';
instance.defaults.headers['X-Requested-With'] = 'XMLHttpRequest'
instance.interceptors.request.use(function (config) {
    // 在发送请求之前做些什么
    if (!config.headers['Content-Type']) {
      config.headers['Content-Type'] = 'application/x-www-form-urlencoded'
    }
    return config;
  }, function (error) {
    // 对请求错误做些什么
    return Promise.reject(error);
  });
instance.interceptors.response.use(function (response) {
    // 在发送请求之前做些什么
    
    if(response.status >= 200 && response.status < 300){
      if (response.data.body.code == '900'){
        Notice.error({render:(h) => {return h('div', {style: {
          paddingRight: '10px',
          fontSize: '14px',
          color: '#17233d'
        }}, '您的账号已在其他地方登录，如不是您个人操作，请及时修改密码')}})
        router.replace({name: 'login'})
      }
      if (response.data.body.code == '901'){
        router.replace({name: 'login'})
      }
      if (response.data.body.code == '902'){
        Notice.error({title:'cookie已失效，请重新登录'})
        router.replace({name: 'login'})
      }
      if(response.data.success){
        return Promise.resolve(response)
      } 
      
      else {
        return Promise.resolve(response);
      }
    } else {
      // return Promise.resolve(response);
    }
    return response;
  }, error => {
    // Notice.error({desc:`${error.response.data.body.message}`})
  });
export default instance
// export default axios
