import axios from '../service/http.service'
import {
  sapi
} from '../config'
import qs from 'qs'
// 账号列表查询
export function queryaccountList (params) {
  return axios.post(`${sapi}/api/user/findList`, params, {
    headers: {
      'Content-Type': 'application/json;'
    }
  })
}
// 添加账户
export function addAccount (params) {
  return axios.post(`${sapi}/api/user/add`, params, {
    headers: {
      'Content-Type': 'application/json'
    }
  })
}
// 删除单条账户
export function Delateaccount (parmars) {
  return axios.get(`${sapi}/api/user/delete/${parmars.id}`, {
    headers: {
      'Content-Type': 'application/json'
    }
  })
}
// 批量删除
export function delateAllAccount (DelateARR) {
  return axios.post(`${sapi}//api/user/delete`, JSON.stringify(DelateARR), {
    headers: {
      'Content-Type': 'application/json'
    }
  })
}
// 恢复初始密码
export function recoveryPassword (parmars) {
  return axios.post(`${sapi}/api/user/initial/${parmars.id}`, {
    headers: {
      'Content-Type': 'application/json'
    }
  })
}
// 查询邮箱列表
export function queryemailList (parmars) {
  return axios.post(`${sapi}/api/email/list`, parmars, {
    headers: {
      'Content-Type': 'application/json'
    }
  })
}
// 同步邮箱
export function Synchronization (parmars) {
  return axios.post(`${sapi}/api/email/bindAndSync`, parmars, {
    headers: {
      'Content-Type': 'application/json'
    }
  })
}
// 解绑邮箱
export function jiebangEmail (id) {
  return axios.post(`${sapi}/api/email/unbind/${id}`, {
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded'
    }
  })
}
// 修改邮箱并重新绑定
export function updateemailTWO (parmars) {
  return axios.post(`${sapi}/api/email/modify`, parmars, {
    headers: {
      'Content-Type': 'application/json'
    }
  })
}
//  批量解绑邮箱
export function UntyingAll (UntyingAllARR) {
  return axios.post(`${sapi}/api/email/unbind/batch`, JSON.stringify(UntyingAllARR), {
    headers: {
      'Content-Type': 'application/json'
    }
  })
}
// 获取二维码
export function getErcode () {
  return axios.get(`${sapi}/api/qrCode/getInterviewQrcode`, {
    headers: {
      'Content-Type': 'application/json'
    }
  })
}
// //修改账户
export function updateAccount (parmars) {
  return axios.post(`${sapi}/api/user/modify/${parmars.id}`, parmars, {
    headers: {
      'Content-Type': 'application/json'
    }
  })
}
