import Vue from 'vue';
import Router from 'vue-router';

const home = r => require.ensure([], () => r(require('@/components/home.vue')), 'home');
// const changepsd = r => require.ensure([], () => r(require('@/components/changepsd.vue')), 'changepsd');
const login = r => require.ensure([], () => r(require('@/page/login/login.vue')), 'login');
const interview = r => require.ensure([], () => r(require('@/page/interview/interview.vue')), 'interview');
const allResume = r => require.ensure([], () => r(require('@/page/resume/allResume.vue')), 'allResume');
const account = r => require.ensure([], () => r(require('@/page/system/account.vue')), 'account');
const emailMange = r => require.ensure([], () => r(require('@/page/system/emailMange.vue')), 'emailMange');
const QRcode = r => require.ensure([], () => r(require('@/page/system/QRcode.vue')), 'QRcode');
const upload = r => require.ensure([], () => r(require('@/page/upload/upload.vue')), 'upload');




Vue.use(Router);

export default new Router({
  // mode: 'history',
  routes: [
    {
      path: '/',
      redirect: '/login',
    }, {
      path: '/login',
      name: 'login',
      component: login,
    },
    // {
    //   path: '/changepsd',
    //   name: 'changepsd',
    //   component: changepsd
    // },
    {
      path: '/home',
      name: 'home',
      component: home,
      children: [
        {
          path: '/interview',
          name: 'interview',
          component: interview
        },
        {
          path: '/allResume',
          name: 'allResume',
          component: allResume
        },
        {
          path: '/account',
          name: 'account',
          component: account
        },
        {
          path: '/emailMange',
          name: 'emailMange',
          component: emailMange
        },
        {
          path: '/QRcode',
          name: 'QRcode',
          component: QRcode
        },
        {
          path: '/upload',
          name: 'upload',
          component: upload
        },
      ]
    },
  ],
});
