import axios from '../service/http.service'
import {
    sapi
} from '../config'
import qs from 'qs'
// 查询简历列表
export function serchList(parmars){
    return axios.post(`${sapi}/api/resume/findList`,parmars,{headers: {
        'Content-Type':'application/json'
    }})
}
// 下载简历（单条）
export function downloadone (parmars) {
    parmars=qs.stringify(parmars)
    return axios.post(`${sapi}/api/resumeFile/download/formatted/one`,parmars,{headers: {
        'Content-Type':'application/x-www-form-urlencoded'
    }})
}
// 搜索
export function sousuoList (parmars) {
    return axios.post(`${sapi}/api/resume/findListByQueryVO`,parmars,{headers: {
        'Content-Type':'application/json'
    }})
}
//查看简历详情页
export function seedetail (parmars) {
    return axios.get(`${sapi}/api/html/get/${parmars.resumeId}?token=${parmars.token}`,{headers: {
        'Content-Type':'application/json'
    }})
}
// 简历pass
export function PASS (parmars) {
    return axios.post(`${sapi}/api/resumeFlow/uploadStatus/${parmars.id}/${parmars.status}`,'',{headers: {
        'Content-Type':'application/json'
    }})
}
//待处理
export function TODORes (parmars) {
    return axios.post(`${sapi}/api/resumeFlow/uploadStatus/${parmars.id}/${parmars.status}`,'',{headers: {
        'Content-Type':'application/json'
    }})
}
// 备选
export function OPTION (parmars) {
    return axios.post(`${sapi}/api/resumeFlow/uploadStatus/${parmars.id}/${parmars.status}`,'',{headers: {
        'Content-Type':'application/json'
    }})
}
// 删除简历
export function deleteREsume (deleteallArr) {
    return axios.post(`${sapi}/api/resume/delete`,JSON.stringify(deleteallArr),{headers: {
        'Content-Type':'application/json'
    }})
}
// 单条下载简历
export function downloadOne (parmars) {
    return axios.get(`${sapi}/api/resume/download/formatted/one?resumeId=${parmars.resumeId}`,{headers: {
        // 'Content-Type':'application/x-www-form-urlencoded'
    }})
}
// 批量下载简历
export function downloadALL () {
    return axios.get(`${sapi}/api/resumeFile/download/formatted/compress`,{headers: {
        'Content-Type':'application/x-www-form-urlencoded'
    }})
}
// 导出列表
export function exportLIST (parmars) {
    return axios.get(`${sapi}/api/excel/output?optSource=${parmars.optSource}&keywordString=${parmars.keywordString}&company=${parmars.company}&ownerSex=${parmars.ownerSex}&highestDegreeNum=${parmars.highestDegreeNum}&flowStatusList=${parmars.flowStatusList}&ownerWorkYears1=${parmars.ownerWorkYears1}&ownerWorkYears2=${parmars.ownerWorkYears2}`,
      {headers: {
        'Content-Type':'application/json'
      }})
}
// 操作记录
export function recodeLIST (parmars) {
    return axios.post(`${sapi}/api/resumeFlow/history/${parmars.resumeId}`,{headers: {
        'Content-Type':'application/json'
    }})
}
//通过某一来源查询简历信息
export function adoptOneSeeResumeList(parmars) {
    return axios.post(`${sapi}/api/resume/findListBySource`,parmars,{headers: {
        'Content-Type':'application/json'
    }})
}
// 新增约面信息
export function addinterview(parmars) {
    return axios.post(`${sapi}/api/resumeInterview/add`,parmars,{headers: {
        'Content-Type':'application/json'
    }})
}
// 修改流程状态
export function updatastatus(parmars) {
    return axios.post(`${sapi}/api/resumeFlow/uploadStatus/${parmars.id}/${parmars.status}`,{headers: {
        'Content-Type':'application/json'
    }})
}
//获取邮件模板
export function getEmailMoo() {
    return axios.post(`${sapi}/api/emailTemplate/getAllTemplateList`,{headers: {
        'Content-Type':'application/json'
    }})
}
//根据获取id邮件模板内容
export function getEmailContent(parmars) {
    return axios.post(`${sapi}/api/emailTemplate/loadTemplate`,parmars,{headers: {
        'Content-Type':'application/json'
    }})
}
//上传图片
export function uploadimage() {
    return axios.get(`${sapi}/api/ckeditor/uploadImage`,{headers: {
        'Content-Type':'application/json'
    }})
}
// 发送邮件
export function sendEmail(parmars) {
    return axios.post(`${sapi}/api/sendMail/sendEmailTemplate`,parmars,{headers: {
        'Content-Type':'multipart/form-data',
        // 'Content-Disposition':'multipart/form-data'
        // 'Content-Type':'application/json'
    }})
}
export function findCompanyEmailByKey(key) { //公司通讯录
    return axios.get(`${sapi}/api/companyEmail/findCompanyEmailByKey?key=${key}`)
}
// 转发邮箱通知
export function forwardResume(params) {
    return axios.post(`${sapi}/api/resume/forwardResume`,params, {headers: {
        'Content-Type':'application/json'
    }})
}

