// 导航配置列表列名
export const columns = function(pointer) {
  return [
    {
      align: 'center',
      title: 'ID',
      key: 'id',
      width: 80
    },
    {
      align: 'center',
      title: '名称',
      key: 'name'
    },
    {
      align: 'center',
      title: '所选页面',
      render: (h, params) => {
        const navigatorData = params.row.navigatorData;
        let str = '';
        try {
          for (let i = 0; i < navigatorData.length; i++) {
            str += `${i + 1}-${navigatorData[i].pageName}; `;
          }
          return h('span', str);
        } catch (e) {
          console.log(e);
        }
        return h('span', str);
      }
    },
    {
      align: 'center',
      title: '作者',
      key: 'author'
    },
    {
      align: 'center',
      title: '更新时间',
      key: 'updatedAt'
    },
    {
      align: 'center',
      title: '操作',
      key: 'updateTime',
      render: (h, params) => {
        const row = params.row;
        return h('div', [
          h('Button', {
            props: {
              type: 'primary',
              size: 'small'
            },
            style: {
              marginRight: '5px'
            },
            on: {
              click: () => {
                pointer.showAddr(row);
              }
            }
          }, '地址列表'),
          // h('Button', {
          //   props: {
          //     type: 'primary',
          //     size: 'small'
          //   },
          //   style: {
          //     marginRight: '5px'
          //   },
          //   on: {
          //     click: () => {
          //       pointer.preview(row);
          //     }
          //   }
          // }, '预览'),
          h('Button', {
            props: {
              type: 'primary',
              size: 'small'
            },
            style: {
              marginRight: '5px'
            },
            on: {
              click: () => {
                pointer.edit(row);
              }
            }
          }, '修改'),
          h('Button', {
            props: {
              type: 'error',
              size: 'small'
            },
            on: {
              click: () => {
                pointer.delete(row);
              }
            }
          }, '删除'),
        ]);
      },
      width: 300
    }
  ];
};

// 地址列表列明
export const urlTableColumns = function(pointer) {
  return [
    {
      align: 'center',
      title: '排序',
      key: 'id',
      width: 80
    },
    {
      align: 'center',
      title: '导航名称',
      key: 'configName',
      width: 120
    },
    {
      align: 'center',
      title: '所选页面',
      key: 'pageName',
      width: 120
    },
    {
      align: 'center',
      title: '跳转链接',
      key: 'pageUrl'
    },
  ];
};