const commodityChannel: object[] = [
  {
    id: 1,
    name: '自营',
  },
  {
    id: 2,
    name: '京东开普勒',
  },
  {
    id: 3,
    name: '京东联盟',
  },
  {
    id: 4,
    name: '众联 ',
  },
  {
    id: 5,
    name: '企业购',
  },
];
const goodsStatus: object[] = [
  {
    id: 1,
    name: '未上架',
  },
  {
    id: 2,
    name: '审核中',
  },
  {
    id: 3,
    name: '已上架',
  },
  {
    id: 4,
    name: '我方下架',
  },
  {
    id: 5,
    name: '三方下架',
  },
];
const columns = function() {
  return [
    {
      type: 'selection',
      width: 60,
      hideSearch: true
    },
    {
      title: '商品ID',
      key: 'id',
      formType: 'input'
    },
    {
      title: 'sku_no',
      key: 'skuNo',
      formType: 'input'
    },
    {
      title: '商品图片',
      key: 'imageUrl',
      width: 130,
      hideSearch: true,
      render: (h, params) => {
        return h('img', {
          attrs: {
            src: params.row.imageUrl,
            width: 50,
            height: 50
          }
        });
      }
    },
    {
      title: '商品名称',
      key: 'skuName',
      width: 155,
      hideSearch: true
    },
    {
      title: '商品渠道',
      key: 'skuSource',
      hideSearch: true,
      render: (h, params) => {
        const obj = commodityChannel.find(item => item.id === params.row.skuSource) || {};
        return h('div', obj.name);
      },
    },
    {
      title: '销售价格',
      key: 'salePrice',
      hideSearch: true
    },
    {
      title: '划线价格',
      key: 'marketPrice',
      hideSearch: true
    },
    {
      title: '发布状态',
      key: 'status',
      formType: 'select',
      valueEnum: goodsStatus.reduce((pre, cur) => {
        pre[cur.id] = cur.name;
        return pre;
      }, {}),
      render: (h, params) => {
        const obj = goodsStatus.find(item => item.id === params.row.status) || {};
        return h('div', obj.name);
      },
    },
    {
      title: '标签',
      hideSearch: true,
      render: (h, params) => {
        const labelName = [];
        if (params.row.labelList) {
          params.row.labelList.forEach(e => {
            labelName.push(e.labelName);
          });
        }
        return h('div', labelName.join(','));
      },
    },
    {
      title: '商品类目',
      key: 'cid1',
      formType: 'treeSelect',
      hideTable: true,
      valueEnum: this.getCategory
    },
  ];
};

export default columns;