import {Component, Prop, Watch, Vue, Mixins, Emit} from 'vue-property-decorator';
import { Getter, State } from 'vuex-class';
import { cloneDeep, uniqBy } from 'lodash';
import Number from '../Number/index.vue';
import QGTable from '@editor/component/QgTable/index.vue';
import { validateType } from '@/service/utils.service';
import operationApi from '@api/operation.api';
import DynamicFormMixin from '../mixins/dynamicForm.mixin';

@Component({ components: { Number, QGTable }, name: 'ComponentSelect' })
export default class DynamicForm extends Mixins(DynamicFormMixin) {
  @State(state => state.editor.curEleIndex) curEleIndex;
  @Getter('pageData') pageData;
  @Prop({ default: () => ([]), type: Array }) formControl;
  @Prop({ default: () => ([]), type: Array }) table;
  @Prop([Object, Array]) value;
  @Prop(String) title;
  @Prop([Object, Array]) templates;

  form: object = {};
  modal: boolean = false;
  selections: object[] = [];
  activeName: number = 0;
  tableData: object[] = [];

  get idsLength() {
    return this.getLength('value');
  }

  // 获取除本页之外的默认值
  getDefaultIds() {
    let defaultIds = this.value;
    if (validateType(this.value) === 'object') {
      defaultIds = this.value?.ids;
    }

    let filterIds = [];
    if (this.table.length > 1) {
      filterIds = this.tableData.map(v => v[this.table[this.activeName].key]);
    } else {
      filterIds = this.tableData.map(v => v.id);
    }

    const rs = defaultIds.filter(v => !filterIds.includes(v));
    return rs;
  }

  // 获取本页的选中值
  getSelectionsIds() {
    if (this.table.length > 1) {
      return this.selections.map(v => v[this.table[this.activeName].key]);
    } else {
      return this.selections.map(v => v.id);
    }
  }

  // 获取本页之外的临时值
  getTemplateIds() {
    let filterIds = [];
    let templates = [];
    if (this.table.length > 1) {
      filterIds = this.tableData.map(v => v[this.table[this.activeName].key]);
      templates = this.templates.ids;
    } else {
      filterIds = this.tableData.map(v => v.id);
      templates = this.templates;
    }

    const rs = templates.filter(v => !filterIds.includes(v));
    return rs;
  }

  getLength(type) {
    const rs = type === 'templates' ? this.templates : this.value;
    if (validateType(this.templates) === 'object') {
      return this.templates?.ids?.length;
    }
    return this.templates?.length;
  }

  // 当table取消全选时的默认值
  getDefaultSelections() {
    let rs = [];
    if (this.table.length > 1) {
      const key = this.table[this.activeName].key;
      rs = [{ [key]: -1 }];
    } else {
      rs = [{ id: -1 }];
    }
    return rs;
  }

  @Watch('curEleIndex', { immediate: true })
  onElementChange(newVal) {
    this.formControl.forEach(schame => {
      this.$set(this.form, schame.key, this.pageData.elements[this.curEleIndex].props[schame.key]);
    });
  }

  @Watch('form', { immediate: true, deep: true })
  onFormChange(newVal) {
    // console.log('onFormChange', newVal);
    let parent = this.$parent;
    while (!parent.modProps) {
      parent = parent.$parent;
    }
    parent.modProps(this.form, 'component');
  }

  add() {
    this.modal = true;
  }

  @Emit('update:templates')
  selectionChange(selection) {
    if (!this.table[this.activeName]?.multiple && selection.length > 1) {
      return this.$Notice.warning({
        title: '商品组只能单选'
      });
    }
    this.selections = selection.length ? selection : this.getDefaultSelections();
    const ids = [...this.getSelectionsIds(), ...(this.getLength('templates') ? this.getTemplateIds() : this.getDefaultIds())];
    console.log('selectionChange', ids, selection);

    let rs = null;
    if (this.table.length > 1) {
      rs = {
        type: this.table[this.activeName].type,
        ids
      };
    } else {
      rs = ids;
    }
    return rs;
  }

  ok() {
    const ids = [...this.getSelectionsIds(), ...(this.getLength('templates') ? this.getTemplateIds() : this.getDefaultIds())].filter(v => v !== -1);
    if (!ids.length) { return; }
    this.selections = [];
    // console.log('commit', selections);
    if (this.table.length > 1) {
      this.$emit('update:templates', {});
      this.$emit('input', {
        type: this.table[this.activeName].type,
        ids
      });
    } else {
      this.$emit('update:templates', []);
      this.$emit('input', ids);
    }
  }

  @Emit('update:templates')
  cancel() {
    this.selections = [];

    let rs = null;
    if (this.table.length > 1) {
      rs = {};
    } else {
      rs = [];
    }
    return rs;
  }

  menuChange(name) {
    this.activeName = name;
    this.selections = [];
  }

  editText(type) {
    let rs = '';
    switch (type) {
    case 'edit':
      rs = `编辑${this.title}`;
      break;
    case 'add':
      rs = `添加${this.title}`;
      break;
    case 'choose':
      rs = `选择${this.title}`;
      break;
    }
    return rs;
  }
}