import {Component, Vue } from 'vue-property-decorator';
import { Mutation } from 'vuex-class';

@Component({ name: 'ContextMenu' })
export class ContextMenu extends Vue {
  @Mutation('COPY_OR_DELETE_PAGE_INFO') updatePageData;
  @Mutation('UPDATE_PAGE_INFO') updatePageInfo;
  @Mutation('UPDATE_COMMON_STYLE') updateCommonStyle;

  show(event, containerIndex, childIndex) {
    console.log('删除', event, containerIndex, childIndex);
    this.$contextmenu({
      items: [
        {
          label: '复制',
          onClick: () => {
            this.updatePageData({type: 'copy', containerIndex, childIndex});
            console.log('复制');
          }
        },
        {
          label: '删除',
          onClick: () => {
            console.log('删除', event, containerIndex, childIndex);
            this.updatePageData({type: 'delete', containerIndex, childIndex});
            // console.log('删除');
          }
        },
      ],
      event,
      minWidth: 100
    });
  }
}