import { cloneDeep } from 'lodash';
import { Component, Prop, Vue } from 'vue-property-decorator';
import { Action, Mutation, State, Getter } from 'vuex-class';
import LoginForm from '@/lib/Form/index.vue';
import { ContextMenu } from '@editor/mixins/contextMenu.mixin';
import { resizeDiv } from '@/service/utils.service';

@Component({ components: { LoginForm }, name: 'FreedomContainer' })
export default class FreedomContainer extends Vue {
  @Getter('pageData') pageData;
  @State(state => state.editor.curChildIndex) curChildIndex;
  @Mutation('UPDATE_PAGE_INFO') updatePageInfo;

  @Prop({type: Object, default: () => ({ child: [] })}) childItem;
  @Prop(String) backgroundImage;

  transformStyle(styleObj) {
    const style = {};
    for (const key of Object.keys(styleObj)) {
      if ( typeof styleObj[key] === 'number') {
        style[key] = `${(styleObj[key] / 37.5).toFixed(3)}rem`;
      } else {
        style[key] = styleObj[key].includes('px') ? `${(+(styleObj[key].slice(0, -2)) / 37.5).toFixed(3)}rem` : styleObj[key];
      }
      if (key === 'backgroundImage') {
        style.backgroundImage = `url(${style.backgroundImage})`;
      }
    }
    return style;
  }

  mounted() {
    // 根据背景图设置元素高度
    const index = this.pageData?.elements?.findIndex(v => v.point?.responsive);
    const { props: { backgroundImage }, point } = this.pageData?.elements[index] || { props: {}};
    if (backgroundImage) {
      resizeDiv(backgroundImage, null, null, (height) => {
        this.updatePageInfo({ containerIndex: index, data: { ...this.pageData?.elements[index], point: { ...point, h: height ?? point.h } } });
      });
    }
  }
}