const commodityChannel: object[] = [
  {
    id: 1,
    name: $t('selfoperated'),
  },
  {
    id: 2,
    name: $t('jd.kepler'),
  },
  {
    id: 3,
    name: $t('jd.union'),
  },
  {
    id: 4,
    name: $t('zhonglian'),
  },
  {
    id: 5,
    name: $t('enterprise.purchase'),
  },
];
const goodsStatus: object[] = [
  {
    id: 1,
    name: $t('not.online'),
  },
  {
    id: 2,
    name: $t('in.review'),
  },
  {
    id: 3,
    name: $t('online'),
  },
  {
    id: 4,
    name: $t('internal.removal'),
  },
  {
    id: 5,
    name: $t('thirdparty.removal'),
  },
];
const columns = function() {
  return [
    {
      type: 'selection',
      width: 60,
      hideSearch: true
    },
    {
      title: $t('product.id'),
      key: 'id',
      formType: 'input'
    },
    {
      title: 'sku_no',
      key: 'skuNo',
      formType: 'input'
    },
    {
      title: $t('product.photo'),
      key: 'imageUrl',
      width: 130,
      hideSearch: true,
      render: (h, params) => {
        return h('img', {
          attrs: {
            src: params.row.imageUrl,
            width: 50,
            height: 50
          }
        });
      }
    },
    {
      title: $t('product.name'),
      key: 'skuName',
      width: 155,
      hideSearch: true
    },
    {
      title: $t('product.channel'),
      key: 'skuSource',
      hideSearch: true,
      render: (h, params) => {
        const obj = commodityChannel.find(item => item.id === params.row.skuSource) || {};
        return h('div', obj.name);
      },
    },
    {
      title: $t('sale.price'),
      key: 'salePrice',
      hideSearch: true
    },
    {
      title: $t('strikethrough.price'),
      key: 'marketPrice',
      hideSearch: true
    },
    {
      title: $t('publish.status'),
      key: 'status',
      formType: 'select',
      valueEnum: goodsStatus.reduce((pre, cur) => {
        pre[cur.id] = cur.name;
        return pre;
      }, {}),
      render: (h, params) => {
        const obj = goodsStatus.find(item => item.id === params.row.status) || {};
        return h('div', obj.name);
      },
    },
    {
      title: $t('tag'),
      hideSearch: true,
      render: (h, params) => {
        const labelName = [];
        if (params.row.labelList) {
          params.row.labelList.forEach(e => {
            labelName.push(e.labelName);
          });
        }
        return h('div', labelName.join(','));
      },
    },
    {
      title: $t('product.category'),
      key: 'cid1',
      formType: 'treeSelect',
      hideTable: true,
      valueEnum: this.getCategory
    },
  ];
};

export default columns;