import { Context, Service } from 'egg';

export default class RecordsService extends Service {
  private context: Context;
  constructor(ctx: Context) {
    super(ctx);
    this.context = ctx;
  }
  async clearInvalidPageHistoryRecords() {
    // 操作记录表直接删除一年以上的操作记录
    const limitDate = new Date(new Date().getTime() - 365 * 24 * 3600 * 1000).toLocaleDateString().replace(/\//g, '-')
    try {
      this.context.logger.info(`${$t('deleting.page.history.from.date')}${limitDate}${$t('all.previous.records')}`);
      await this.context.model.PageHistory.destroy({
        where: {
          updated_at: {
            $lte: new Date(limitDate)
          }
        }
      });
      this.context.logger.info(`${$t('page.history.deleted.from.date')}${limitDate}${$t('all.previous.records')}`);
    } catch (err) {
      this.context.logger.info(`${$t('failed.to.delete.page.history')}${JSON.stringify(err)}`);
    }
    return;
  }
}
