import {Component, Mixins, Prop, Watch} from 'vue-property-decorator';
import { Getter, State } from 'vuex-class';
import { reduce, ceil, subtract, divide, cloneDeep, assign } from 'lodash';
import ContextMenuMixin from '@editor/mixins/contextMenu.mixin';
import Upload from '../DynamicForm/component/Upload/index.vue';
import ColorSelector from '../DynamicForm/component/ColorSelector/index.vue';
import CouponModalSelector from '../DynamicForm/component/CouponModalSelector/index.vue'; // 用于选择优惠券弹窗
import BaseSelect from '../DynamicForm/component/BaseSelect/index.vue';
import Textarea from '../DynamicForm/component/Textarea/index.vue';
import Number from '../DynamicForm/component/Number/index.vue';
import FormList from '../DynamicForm/component/FormList/index.vue';
import BackTopPicker from '../DynamicForm/component/BackTopPicker/index.vue';
import SwitchBtn from '../DynamicForm/component/SwitchBtn/index.vue';
import { SHOP_CART_CONFIG, DEFAULT_CONFIG } from '@service/staticData.service';

@Component({ components: { Upload, ColorSelector, BaseSelect, Textarea, Number, FormList, BackTopPicker, SwitchBtn, CouponModalSelector }, name: 'DynamicPageForm' })
export default class DynamicPageForm extends Mixins(ContextMenuMixin) {
  @Getter('pageData') pageData;
  @State(state => state.tenant.cartAndShareBtn) cartAndShareBtn;

  title: string = $t('page');
  commonStyleForm: object = {};
  propsForm: object = {};
  commonStyleSchame: object[] = [
    {
      key: 'backgroundImage',
      name: $t('background.image'),
      type: 'Upload',
    },
    {
      key: 'backgroundColor',
      name: $t('background.color'),
      type: 'ColorSelector'
    }
  ];
  baseConfigSchema: object[] = [
    {
      key: 'pageNeedLogin',
      name: $t('logged.in'),
      type: 'SwitchBtn'
    },
  ]; ,
  titleSchema: object[] = [
    {
      key: 'titleBgColor',
      name: $t('background.color'),
      type: 'ColorSelector',
      props: {
        gradient: true,
        alpha: false
      }
    },
    // 支持运营内部福利赛需求，包括优惠券组件也做了处理，如果后期不用，可以考虑下线
    {
      key: 'titleUseUrl',
      name: $t('fetch.title.from.url'),
      type: 'SwitchBtn'
    },
  ];
  bottomSchema: object[] = [
    {
      key: 'showPageBottomTip',
      name: $t('status'),
      type: 'SwitchBtn'
    },
    {
      key: 'pageBottomTxt',
      name: $t('hint.text'),
      type: 'Input'
    },
    {
      key: 'pageBottomColor',
      name: $t('hint.color'),
      type: 'ColorSelector'
    },
  ];
  floatSchema: object[] = [
    {
      key: 'showBackTop',
      name: $t('back.to.top'),
      type: 'SwitchBtn'
    },
    {
      key: 'btAttachVal',
      name: $t('add.button'),
      desc: $t('add.button'),
      type: 'BackTopPicker',
      formControl: [
        {
          key: 'persets',
          name: $t('preset.attributes'),
          type: 'select',
          options: [$t('shopping.cart'), $t('share'), $t('custom')]
        },
        {
          key: 'name',
          name: $t('name'),
          type: 'text',
          props: {
            require: true,
            placeholder: $t('required.tracking.point')
          }
        },
        {
          key: 'txt',
          name: $t('text'),
          type: 'text',
          props: {
            placeholder: $t('optional.text.below.icon'),
          }
        },
        {
          key: 'url',
          name: $t('link'),
          type: 'text'
        },
        {
          key: 'icon',
          name: $t('image'),
          type: 'Upload'
        },
        {
          key: 'color',
          name: $t('text.color'),
          type: 'ColorSelector'
        },
        {
          key: 'iconColor',
          name: $t('icon.color'),
          type: 'ColorSelector'
        },
        {
          key: 'background',
          name: $t('background.color'),
          type: 'ColorSelector'
        },
        {
          key: 'size',
          name: $t('size'),
          type: 'Slider',
          props: {
            min: 14,
            max: 68
          }
        },
        {
          key: 'iconSize',
          name: $t('icon.size'),
          type: 'Slider',
          props: {
            min: 14,
            max: 68
          }
        },
        {
          key: 'radius',
          name: $t('border.radius'),
          type: 'checkbox'
        },
        {
          key: 'shadow',
          name: $t('shadow'),
          type: 'checkbox'
        }
      ],
      formDefault: {}
    }
  ];
  floatModal: object[] = [
    {
      key: 'couponModal',
      name: $t('coupon.popup'),
      type: 'CouponModalSelector'
    },
  ];
  // 这块用于让被污染的pageInfo的page.props返回shareOpenMethod
  otherProps: object[] = [
    {
      key: 'shareOpenMethod'
    },
    {
      key: 'diversion'
    },
    {
      key: 'shareCoverImage'
    },
  ];
  get propsSchema() {
    return [...this.titleSchema, ...this.bottomSchema, ...this.floatSchema, ...this.otherProps, ...this.floatModal, ...this.baseConfigSchema];
  }

  @Watch('cartAndShareBtn', { immediate: true })
  onAuthStateChange(val) {
    const options = val ? [$t('shopping.cart'), $t('share'), $t('custom')] : [$t('custom')];
    this.$set(this.floatSchema[1].formControl[0], 'options', options);
    this.$set(this.floatSchema[1], 'formDefault', val ? SHOP_CART_CONFIG : DEFAULT_CONFIG);
  }

  @Watch('pageData', { immediate: true, deep: true })
  onElementChange() {
    this.commonStyleSchame.forEach(schame => {
      this.$set(this.commonStyleForm, schame.key, this.pageData?.commonStyle[schame.key]);
    });
    this.propsSchema.forEach(schame => {
      this.$set(this.propsForm, schame.key, this.pageData?.props?.[schame.key]);
    });
    // console.log(this.propsForm);
  }

  @Watch('commonStyleForm', { immediate: true, deep: true })
  onCommonStyleFormChange(newVal) {
    this.$emit('modProps', newVal, 'page', 'commonStyle');
  }

  @Watch('propsForm', { immediate: true, deep: true })
  onPropsFormChange(newVal) {
    this.$emit('modProps', newVal, 'page', 'props');
  }
}