const couponTypeList: object[] = [
  {
    id: 1,
    name: $t('discount.coupon'),
  },
  {
    id: 2,
    name: $t('shipping.coupon'),
  },
  {
    id: 3,
    name: $t('cash.coupon'),
  },
  {
    id: 21,
    name: $t('huabei.coupon'),
  },

];
const receiverTypeList: object[] = [
  {
    id: 1,
    name: $t('active.claim'),
  },
  {
    id: 2,
    name: $t('system.issued'),
  },
  // {
  //   id: 3,
  //   name: '不限',
  // },
];
const listStatus: object[] = [
  {
    id: 'WAIT_ON_LINE',
    name: $t('pending.publish'),
  },
  {
    id: 'ON_LINE',
    name: $t('online'),
  },
  {
    id: 'OFF_LINE',
    name: $t('offline'),
  },
];
const statusList: object[] = [
  {
    id: 1,
    name: $t('pending.publish'),
  },
  {
    id: 2,
    name: $t('online'),
  },
  {
    id: 3,
    name: $t('offline'),
  },
  {
    id: 4,
    name: $t('expired'),
  },
];
const columns: object[] = [
  {
    type: 'selection',
    width: 60,
    hideSearch: true
  },
  {
    title: $t('batch.id'),
    key: 'id',
    hideSearch: true
  },
  {
    title: $t('batch.id'),
    hideTable: true,
    key: 'couponId',
    formType: 'input'
  },
  {
    title: $t('coupon.name'),
    key: 'name',
    hideSearch: true
  },
  {
    title: $t('coupon.type'),
    key: 'couponType',
    formType: 'select',
    valueEnum: couponTypeList.reduce((pre, cur) => {
      pre[cur.id] = cur.name;
      return pre;
    }, {}),
    render: (h, params) => {
      const obj = couponTypeList.find(item => item.id === params.row.couponType) || {};
      return h('div', obj.name);
    },
  },
  {
    title: $t('coupon.value'),
    key: 'couponAmt',
    hideSearch: true,
  },
  {
    title: $t('coupon.attribute'),
    key: '',
    hideSearch: true,
    render: (h, params) => {
      const obj = params.row.couponType === 1 ? `${$t('full')}${params.row.limitAmt}${$t('minus')}${params.row.couponAmt}${$t('yuan')}` : `${$t('full')}${params.row.limitAmt}${$t('available')}`;
      return h('div', obj);
    },
  },
  {
    title: $t('issue.quantity'),
    key: 'pushCount',
    hideSearch: true,
  },
  {
    title: $t('issue.period'),
    key: 'receiverTime',
    hideSearch: true
  },
  {
    title: $t('usage.period'),
    key: 'useTime',
    hideSearch: true
  },
  {
    title: $t('claim.method'),
    formType: 'select',
    key: 'receiverType',
    valueEnum: receiverTypeList.reduce((pre, cur) => {
      pre[cur.id] = cur.name;
      return pre;
    }, {}),
    render: (h, params) => {
      const obj = receiverTypeList.find(item => item.id === params.row.receiverType) || {};
      // 处理优惠券列表显示券码的问题
      if (+params.row.receiverType === 4) {  return h('div', $t('coupon.redemption')); }
      return h('div', obj.name);
    },
  },
  {
    title: $t('status'),
    key: 'status',
    hideSearch: true,
    render: (h, params) => {
      const obj = listStatus.find(item => item.id === params.row.status) || {};
      return h('div', obj.name);
    }
  },
  {
    title: $t('status'),
    key: 'status',
    formType: 'select',
    hideTable: true,
    valueEnum: statusList.reduce((pre, cur) => {
      pre[cur.id] = cur.name;
      return pre;
    }, {}),
  }
];

export default columns;