import {Component, Prop, Watch, Vue} from 'vue-property-decorator';
import TableModal from '../TableModal/index.vue';
import couponColumn from './columns/coupon.column';
import { cloneDeep } from 'lodash';
import operationApi from '@api/operation.api';

@Component({ components: { TableModal }, name: 'CouponTableModal' })
export default class CouponTableModal extends Vue {
  @Prop({ default: () => ([]), type: Array }) value;
  @Prop({ default: () => ([]), type: Array }) formControl;

  coupon: object[] = cloneDeep(this.value);
  templates: object[] = [];
  table: object[] = [
    {
      title: $t('select.coupon'),
      type: 'coupon',
      multiple: true,
      columns: couponColumn,
      query: this.query
    }
  ];

  @Watch('coupon')
  onFormChange(newVal) {
    this.$emit('input', newVal);
  }

  async query(data) {
    // receiverType 领取方式 1：主动领取 2：自动发放 3：不限, 4:券码
    const res = await operationApi.couponList({ ...data });
    const couponInfoList = res?.couponInfoList?.map(item => {
      if (item.receiverStartTime && item.receiverEndTime) {
        item.receiverTime = `${item.receiverStartTime.slice(0, 10)}--${item.receiverEndTime.slice(0, 10)}`;
      }
      if (item.useTimeStart && item.useTimeEnd) {
        item.useTime = item.useTimeStart
        ? `${item.useTimeStart}-${item.useTimeEnd}`
        : item.validHours
        ? `${$t('valid.since.claim')}${item.validHours}${$t('hours')}`
        : `${$t('valid.after.claim')}${item.receiverDaysValid}${$t('takes.effect.in.days.valid.for.1.days')}${item.validDays}${$t('days')}`;
        // item.useTime = item.useTimeStart ? `${item.useTimeStart}-${item.useTimeEnd}` : `自领取${item.receiverDaysValid}天后生效，有效天数${item.validDays}天`;
      }
      const selections = this.templates.length ? this.templates : this.coupon;
      console.log('query', selections, this.templates, this.coupon);
      if (selections.some(v => v === item.id)) {
        item._checked = true;
      }
      return item;
    });

    return { data: couponInfoList.map(item => {
      if (+item.receiverType === 4) {
        item._disabled = true;
      }
      return item;
    }) || [], total: res?.pageInfo?.totalCount };
  }
}