/**
 * @desc 页面信息表
 */
import { AutoIncrement, Column, DataType, Model, PrimaryKey, Table, AllowNull } from 'sequelize-typescript';

@Table({
  modelName: 'tenant_auth_info',
  freezeTableName: true
})

export class TenantAuth extends Model<TenantAuth> {

  @PrimaryKey
  @AutoIncrement
  @Column({
    type: DataType.INTEGER(11)
  })
  id: number;

  @AllowNull(false)
  @Column({
    type: DataType.INTEGER(11),
    field: 'tenant_id',
  })
  tenantId: number;

  @Column({
    field: 'tenant_name',
    type: DataType.STRING(32)
  })
  tenantName: string;

  @Column({
    field: 'auth_config',
    type: DataType.TEXT
  })
  authConfig: string;

  @Column({
    field: 'config_desc',
    type: DataType.STRING(255)
  })
  configDesc: string;

  @Column({
    type: DataType.INTEGER(1)
  })
  enable: number;

  @Column({
    type: DataType.DATE,
    field: 'updated_at',
    get() {
      const moment = require('moment');
      const updatedAt = this.getDataValue('updatedAt');
      return moment(updatedAt).format('YYYY-MM-DD HH:mm:ss');
    },
  })
  updatedAt: string;
  
}

export default () => TenantAuth;