#!/usr/bin/env node
const path = require('path');
const apollo = require('@qg/apollo-nodejs');

"use strict";
const npm = require("npm");
npm.load(() => {
  apollo.load({
    appId: 'quantum-blocks',
    configPath: path.resolve(__dirname, '../app/web/config'),
  }).then(() => {
    if (process.env.NODE_ENV === 'production') {
      npm.run("start"); 
    } else {
      npm.run("test");
    }
  });
});