const couponTypeList: object[] = [
  {
    id: 1,
    name: '满减券',
  },
  {
    id: 2,
    name: '运费券',
  },
  {
    id: 3,
    name: '现金券',
  },
  {
    id: 21,
    name: '享花券',
  },

];
const receiverTypeList: object[] = [
  {
    id: 1,
    name: '主动领取',
  },
  {
    id: 2,
    name: '系统发放',
  },
  // {
  //   id: 3,
  //   name: '不限',
  // },
];
const listStatus: object[] = [
  {
    id: 'WAIT_ON_LINE',
    name: '待发布',
  },
  {
    id: 'ON_LINE',
    name: '已上架',
  },
  {
    id: 'OFF_LINE',
    name: '已下架',
  },
];
const statusList: object[] = [
  {
    id: 1,
    name: '待发布',
  },
  {
    id: 2,
    name: '已上架',
  },
  {
    id: 3,
    name: '已下架',
  },
  {
    id: 4,
    name: '已过期',
  },
];
const columns: object[] = [
  {
    type: 'selection',
    width: 60,
    hideSearch: true
  },
  {
    title: '批次id',
    key: 'id',
    hideSearch: true
  },
  {
    title: '批次id',
    hideTable: true,
    key: 'couponId',
    formType: 'input'
  },
  {
    title: '优惠券名称',
    key: 'name',
    hideSearch: true
  },
  {
    title: '优惠券类型',
    key: 'couponType',
    formType: 'select',
    valueEnum: couponTypeList.reduce((pre, cur) => {
      pre[cur.id] = cur.name;
      return pre;
    }, {}),
    render: (h, params) => {
      const obj = couponTypeList.find(item => item.id === params.row.couponType) || {};
      return h('div', obj.name);
    },
  },
  {
    title: '优惠券面值',
    key: 'couponAmt',
    hideSearch: true,
  },
  {
    title: '优惠券属性',
    key: '',
    hideSearch: true,
    render: (h, params) => {
      const obj = params.row.couponType === 1 ? `满${params.row.limitAmt}减${params.row.couponAmt}元` : `满${params.row.limitAmt}可用`;
      return h('div', obj);
    },
  },
  {
    title: '发行数量',
    key: 'pushCount',
    hideSearch: true,
  },
  {
    title: '发行有效期',
    key: 'receiverTime',
    hideSearch: true
  },
  {
    title: '使用有效期',
    key: 'useTime',
    hideSearch: true
  },
  {
    title: '领取方式',
    formType: 'select',
    key: 'receiverType',
    valueEnum: receiverTypeList.reduce((pre, cur) => {
      pre[cur.id] = cur.name;
      return pre;
    }, {}),
    render: (h, params) => {
      const obj = receiverTypeList.find(item => item.id === params.row.receiverType) || {};
      return h('div', obj.name);
    },
  },
  {
    title: '状态',
    key: 'status',
    hideSearch: true,
    render: (h, params) => {
      const obj = listStatus.find(item => item.id === params.row.status) || {};
      return h('div', obj.name);
    }
  },
  {
    title: '状态',
    key: 'status',
    formType: 'select',
    hideTable: true,
    valueEnum: statusList.reduce((pre, cur) => {
      pre[cur.id] = cur.name;
      return pre;
    }, {}),
  }
];

export default columns;