const groupColumns = function() {
  return [
    {
      type: 'selection',
      width: 60,
      hideSearch: true
    },
    {
      title: $t('topic.id'),
      key: 'id',
      formType: 'input'
    },
    {
      title: $t('topic.name'),
      key: 'name',
      formType: 'input'
    },
    {
      title: $t('validity.period'),
      key: 'validityTime',
      hideSearch: true,
      render: (h, params) => {
        const time = `${params.row.startTime} 至 ${params.row.endTime}`;
        return h('div', time);
      },
    },
    {
      title: $t('tag'),
      key: 'labelName',
      hideSearch: true,
      render: (h, params) => {
        const labelName = [];
        params.row?.listLabel?.forEach(e => {
          labelName.push(e.labelName);
        });
        return h('div', labelName.join(','));
      },
    },
    {
      title: $t('create.time'),
      key: 'createdAt',
      hideSearch: true,
    }
  ];
};

export default groupColumns;