// 导航配置列表列名
export const columns = function(pointer) {
  return [
    {
      align: 'center',
      title: 'ID',
      key: 'id',
      width: 80
    },
    {
      align: 'center',
      title: $t('name'),
      key: 'name'
    },
    {
      align: 'center',
      title: $t('selected.page'),
      render: (h, params) => {
        const navigatorData = params.row.navigatorData;
        let str = '';
        try {
          for (let i = 0; i < navigatorData.length; i++) {
            str += `${i + 1}-${navigatorData[i].pageName}; `;
          }
          return h('span', str);
        } catch (e) {
          console.log(e);
        }
        return h('span', str);
      }
    },
    {
      align: 'center',
      title: $t('author'),
      key: 'author'
    },
    {
      align: 'center',
      title: $t('update.time'),
      key: 'updatedAt'
    },
    {
      align: 'center',
      title: $t('action'),
      key: 'updateTime',
      render: (h, params) => {
        const row = params.row;
        return h('div', [
          h('Button', {
            props: {
              type: 'primary',
              size: 'small'
            },
            style: {
              marginRight: '5px'
            },
            on: {
              click: () => {
                pointer.showAddr(row);
              }
            }
          }, $t('address.list')),
          // h('Button', {
          //   props: {
          //     type: 'primary',
          //     size: 'small'
          //   },
          //   style: {
          //     marginRight: '5px'
          //   },
          //   on: {
          //     click: () => {
          //       pointer.preview(row);
          //     }
          //   }
          // }, '预览'),
          h('Button', {
            props: {
              type: 'primary',
              size: 'small'
            },
            style: {
              marginRight: '5px'
            },
            on: {
              click: () => {
                pointer.edit(row);
              }
            }
          }, $t('edit')),
          h('Button', {
            props: {
              type: 'error',
              size: 'small'
            },
            on: {
              click: () => {
                pointer.delete(row);
              }
            }
          }, $t('delete')),
        ]);
      },
      width: 300
    }
  ];
};

// 地址列表列明
export const urlTableColumns = function(pointer) {
  return [
    {
      align: 'center',
      title: $t('sort'),
      key: 'id',
      width: 80
    },
    {
      align: 'center',
      title: $t('nav.name'),
      key: 'configName',
      width: 120
    },
    {
      align: 'center',
      title: $t('selected.page'),
      key: 'pageName',
      width: 120
    },
    {
      align: 'center',
      title: $t('redirect.link'),
      key: 'pageUrl'
    },
  ];
};