import {Component, Mixins, Prop, Watch} from 'vue-property-decorator';
import { Getter, State } from 'vuex-class';
import { reduce, ceil, subtract, divide, cloneDeep, assign } from 'lodash';
import ContextMenuMixin from '@editor/mixins/contextMenu.mixin';
import Upload from '../DynamicForm/component/Upload/index.vue';
import ColorSelector from '../DynamicForm/component/ColorSelector/index.vue';
import BaseSelect from '../DynamicForm/component/BaseSelect/index.vue';
import Textarea from '../DynamicForm/component/Textarea/index.vue';
import Number from '../DynamicForm/component/Number/index.vue';
import FormList from '../DynamicForm/component/FormList/index.vue';
import BackTopPicker from '../DynamicForm/component/BackTopPicker/index.vue';
import SwitchBtn from '../DynamicForm/component/SwitchBtn/index.vue';
import { SHOP_CART_CONFIG, DEFAULT_CONFIG } from '@service/staticData.service';

@Component({ components: { Upload, ColorSelector, BaseSelect, Textarea, Number, FormList, BackTopPicker, SwitchBtn }, name: 'DynamicPageForm' })
export default class DynamicPageForm extends Mixins(ContextMenuMixin) {
  @Getter('pageData') pageData;
  @State(state => state.tenant.cartAndShareBtn) cartAndShareBtn;

  title: string = '页面';
  commonStyleForm: object = {};
  propsForm: object = {};
  commonStyleSchame: object[] = [
    {
      key: 'backgroundImage',
      name: '背景图片',
      type: 'Upload',
    },
    {
      key: 'backgroundColor',
      name: '背景颜色',
      type: 'ColorSelector'
    }
  ];
  titleSchema: object[] = [
    {
      key: 'titleBgColor',
      name: '背景色',
      type: 'ColorSelector',
      props: {
        gradient: true,
        alpha: false
      }
    },
    // 支持运营内部福利赛需求，包括优惠券组件也做了处理，如果后期不用，可以考虑下线
    {
      key: 'titleUseUrl',
      name: '从URL中获取标题',
      type: 'SwitchBtn'
    },
  ];
  bottomSchema: object[] = [
    {
      key: 'showPageBottomTip',
      name: '状态',
      type: 'SwitchBtn'
    },
    {
      key: 'pageBottomTxt',
      name: '提示文案',
      type: 'Input'
    },
    {
      key: 'pageBottomColor',
      name: '提示颜色',
      type: 'ColorSelector'
    },
  ];
  floatSchema: object[] = [
    {
      key: 'showBackTop',
      name: '返回顶部',
      type: 'SwitchBtn'
    },
    {
      key: 'btAttachVal',
      name: '添加按钮',
      desc: '添加按钮',
      type: 'BackTopPicker',
      formControl: [
        {
          key: 'persets',
          name: '预设属性',
          type: 'select',
          options: ['购物车', '分享', '自定义']
        },
        {
          key: 'name',
          name: '名称',
          type: 'text',
          props: {
            require: true,
            placeholder: '(必填) 区分埋点'
          }
        },
        {
          key: 'txt',
          name: '文字',
          type: 'text',
          props: {
            placeholder: '(选填) 图标下方文字',
          }
        },
        {
          key: 'url',
          name: '链接',
          type: 'text'
        },
        {
          key: 'icon',
          name: '图片',
          type: 'Upload'
        },
        {
          key: 'color',
          name: '文字颜色',
          type: 'ColorSelector'
        },
        {
          key: 'iconColor',
          name: '图标颜色',
          type: 'ColorSelector'
        },
        {
          key: 'background',
          name: '背景颜色',
          type: 'ColorSelector'
        },
        {
          key: 'size',
          name: '尺寸',
          type: 'Slider',
          props: {
            min: 14,
            max: 68
          }
        },
        {
          key: 'iconSize',
          name: '图标尺寸',
          type: 'Slider',
          props: {
            min: 14,
            max: 68
          }
        },
        {
          key: 'radius',
          name: '圆角',
          type: 'checkbox'
        },
        {
          key: 'shadow',
          name: '阴影',
          type: 'checkbox'
        }
      ],
      formDefault: {}
    }
  ];
  get propsSchema() {
    return [...this.titleSchema, ...this.bottomSchema, ...this.floatSchema];
  }

  @Watch('cartAndShareBtn', { immediate: true })
  onAuthStateChange(val) {
    const options = val ? ['购物车', '分享', '自定义'] : ['自定义'];
    this.$set(this.floatSchema[1].formControl[0], 'options', options);
    this.$set(this.floatSchema[1], 'formDefault', val ? SHOP_CART_CONFIG : DEFAULT_CONFIG);
  }

  @Watch('pageData', { immediate: true, deep: true })
  onElementChange() {
    this.commonStyleSchame.forEach(schame => {
      this.$set(this.commonStyleForm, schame.key, this.pageData?.commonStyle[schame.key]);
    });
    this.propsSchema.forEach(schame => {
      this.$set(this.propsForm, schame.key, this.pageData?.props?.[schame.key]);
    });
  }

  @Watch('commonStyleForm', { immediate: true, deep: true })
  onCommonStyleFormChange(newVal) {
    this.$emit('modProps', newVal, 'page', 'commonStyle');
  }

  @Watch('propsForm', { immediate: true, deep: true })
  onPropsFormChange(newVal) {
    this.$emit('modProps', newVal, 'page', 'props');
  }
}