import Vue from 'vue';
import VueRouter from 'vue-router';
import Dashboard from '../view/dashboard/index.vue';
import PageList from '../view/pageList/index.vue';
import myPage from '../view/myPage/index.vue';
import template from '../view/template/index.vue';
import localStorage from '@/service/localStorage.service';

Vue.use(VueRouter);

const originalPush = VueRouter.prototype.push;
VueRouter.prototype.push = function push(location) {
  return originalPush.call(this, location).catch(err => err);
};
VueRouter.prototype.replace = function push(location) {
  return originalPush.call(this, location).catch(err => err);
};

export default function createRouter() {
  const router = new VueRouter({
    mode: 'history',
    base: '/editor/',
    routes: [
      {
        path: '/',
        redirect: 'list'
      },
      {
        name: 'detail',
        path: '/detail/:pageId?',
        component: () => import('../view/dashboard/index.vue')
      },
      {
        name: 'list',
        path: '/list',
        component: () => import('../view/pageList/index.vue')
      },
      {
        name: 'my',
        path: '/my',
        component: () => import('../view/myPage/index.vue')
      },
      {
        name: 'template',
        path: '/template',
        component: () => import('../view/template/index.vue')
      },
    ]
  });

  router.beforeEach(async (to, from, next) => {
    if (to.path !== '/login') {
      if (!localStorage.get('token')) {
        return window.location.href = '/editor/login';
      }
    }

    next();
  });

  return router;
}
