import {Component, Prop, Watch, Vue} from 'vue-property-decorator';
import TableModal from '../TableModal/index.vue';
import couponColumn from './columns/coupon.column';
import { cloneDeep } from 'lodash';
import operationApi from '@api/operation.api';

@Component({ components: { TableModal }, name: 'CouponTableModal' })
export default class CouponTableModal extends Vue {
  @Prop({ default: () => ([]), type: Array }) value;
  @Prop({ default: () => ([]), type: Array }) formControl;

  goods: object = cloneDeep(this.value);
  table: object[] = [
    {
      title: '选择优惠券',
      type: 'coupon',
      multiple: true,
      columns: couponColumn,
      query: this.query
    }
  ];

  @Watch('goods')
  onFormChange(newVal) {
    this.$emit('input', newVal);
  }

  async query(data) {
    const res = await operationApi.couponList(data);
    const couponInfoList = res?.couponInfoList?.map(item => {
      item.receiverTime = `${item.receiverStartTime.slice(0, 10)}--${item.receiverEndTime.slice(0, 10)}`;
      item.useTime = item.useTimeStart ? `${item.useTimeStart}-${item.useTimeEnd}` : `自领取${item.receiverDaysValid}天后生效，有效天数${item.validDays}天`;
      return item;
    });

    return { data: couponInfoList || [], total: res?.pageInfo?.totalCount };
  }
}