import {Component, Mixins, Prop, Watch} from 'vue-property-decorator';
import { Getter, State } from 'vuex-class';
import { reduce, ceil, subtract, divide } from 'lodash';
import ContextMenuMixin from '@editor/mixins/contextMenu.mixin';
import Upload from '../DynamicForm/component/Upload/index.vue';
import ColorSelector from '../DynamicForm/component/ColorSelector/index.vue';
import BaseSelect from '../DynamicForm/component/BaseSelect/index.vue';
import Textarea from '../DynamicForm/component/Textarea/index.vue';
import Number from '../DynamicForm/component/Number/index.vue';
import { resizeDiv, getStyle } from '@/service/utils.service';

@Component({ components: { Upload, ColorSelector, BaseSelect, Textarea, Number }, name: 'DynamicForm' })
export default class DynamicPageForm extends Mixins(ContextMenuMixin) {
  @Getter('pageData') pageData;

  title: string = '页面背景';
  form: object = {};
  schame: object[] = [
    {
      key: 'backgroundImage',
      name: '背景图片',
      type: 'Upload'
    },
    {
      key: 'backgroundColor',
      name: '背景颜色',
      type: 'ColorSelector'
    },
  ];

  @Watch('pageData', { immediate: true, deep: true })
  onElementChange(newVal) {
    const keys = Object.keys(this.schame);
    // this.form = {};
    this.schame.forEach(schame => {
      this.$set(this.form, schame.key, this.pageData?.commonStyle[schame.key]);
    });
  }

  @Watch('form', { immediate: true, deep: true })
  onFormChange(newVal) {
    this.$emit('modProps', this.form, 'page');
  }

  // resizedChildEvent(type) {
  //   this.$emit('resizedChildEvent', type);
  //   // const containerEle = this.$refs.freedomContainer[this.curEleIndex];
  // }
}