import http from '../service/http.service';
import config from '../config';

export default {
  getPageList(params) {
    return http.get('editor/get/list', { params });
  },
  getPageById(params) {
    return http.get(`editor/get/${params.pageId}`);
  },
  delPageById(pageId) {
    return http.delete(`editor/${pageId}`);
  },
  updatePage(params) {
    return http.post(`editor/update`, params);
  },
  savePage(params) {
    return http.post(`editor/save`, params);
  },
  getTemplateList() {
    return http.get('editor/get/template');
  },
  // 商品列表-查询
  skuInfo(params) {
    return http.post(`${config.opapiHost}/kdspOp/api/kdsp/activity/activity-goods/sku-info/list`, params, {
      accessToken: true
    });
  },
  // 获取商品类目
  categoryQuery() {
    return http.get(`${config.opapiHost}/kdspOp/api/kdsp/op/rear-category/query/all`, {
      accessToken: true
    });
  },
  // 优惠券搜索列表
  couponList(params) {
    return http.post(`${config.opapiHost}/kdspOp/api/kdsp/op/coupon/list`, params, {
      accessToken: true
    });
  },
  // 商品管理-商品专题列表_分页
  specialPage(params) {
    return http.post(`${config.opapiHost}/kdspOp/api/kdsp/activity/activity-goods/special/list-page`, params, {
      accessToken: true
    });
  },
};