export default {
  get(key) {
    const result = EASY_ENV_IS_BROWSER && window.localStorage.getItem(key);
    try {
      return JSON.parse(result as string);
    } catch (e) {
      return result;
    }
  },
  set(key, value) {
    if (value === undefined) { return; }
    const toString = Object.prototype.toString;
    if (toString.call(value) === '[object Array]' || toString.call(value) === '[object Object]') {
      value = JSON.stringify(value);
    }

    return EASY_ENV_IS_BROWSER && window.localStorage.setItem(key, value);
  },
  remove(key) {
    return EASY_ENV_IS_BROWSER && window.localStorage.removeItem(key);
  },
  clear() {
    return EASY_ENV_IS_BROWSER && window.localStorage.clear();
  }
};
