FROM node:14-alpine AS builder

WORKDIR /app
COPY package*.json ./
RUN ["npm", "install", "--production", "--registry=http://npmprivate.quantgroups.com/"]

FROM node:14-alpine

WORKDIR /home/quant_group
COPY --from=builder /app/node_modules ./node_modules
COPY . .
RUN ["npm", "run", "tsc"]
# 加载 apollo 时必须有这个环境变量
ARG NAMESPACE=bfe
# build 时间较长，实际做了什么
# "build:test": "cross-env NODE_ENV=test APOLLO_CLUSTER=k8s npm run apollo && cross-env NODE_ENV=production COS_ENV=production easy build --devtool",
RUN ["npm", "run", "build:test"]

EXPOSE 80
# 为什么又加载一遍 apollo
CMD ["node", "bin/server.js"]