export interface Page {
  elements: any[];
}

export interface PageInfo {
  id?: number;
  page?: Page | string;
  enable?: number;
  author?: string;
  coverImage?: string;
  isTemplate?: number;
  isPublish?: number;
}

export default interface EditorState {
  pageInfo: PageInfo;
  draggable: boolean;
  curEleIndex: number | null;
  curChildIndex: number | null;
}

export const defaultState = {
  draggable: true,
  curEleIndex: null,
  curChildIndex: null,
  pageInfo: {
    id: 0,
    pageName: '',
    pageDescribe: '',
    coverImage: 'http://desk.fd.zol-img.com.cn/g5/M00/00/07/ChMkJ1ZqMb2IWITEAAbRDaofaNIAAGBHwO3hh0ABtEl380.jpg',
    showDownload: false,
    isPublish: false,
    page: {
      elements: [],
    }
  }
};