import {Component, Mixins, Prop, Watch} from 'vue-property-decorator';
import { Getter, State } from 'vuex-class';
import { reduce, ceil, subtract, divide } from 'lodash';
import { ContextMenu } from '@editor/mixins/contextMenu.mixin';
import Upload from './component/Upload/index.vue';

@Component({ components: { Upload }, name: 'DynamicForm' })
export default class DynamicForm extends Mixins(ContextMenu) {
  @State(state => state.editor.curEleIndex) curEleIndex;
  @State(state => state.editor.curChildIndex) curChildIndex;
  @Getter('pageData') pageData;

  @Prop({type: Object, default: () => ({ schame: { config: [], value: [] }, props: {} })}) curElement;

  form: object = {};

  @Watch('curElement', { immediate: true, deep: true })
  onElementChange(newVal) {
    this.form = reduce(newVal.schame, (obj, param) => {
      obj[param.key] = newVal.props[param.key];
      return obj;
    }, {});
  }

  get eleName() {
    let result = '';
    if (!this.curChildIndex && this.curChildIndex !== 0) {
      result = this.pageData?.elements[this.curEleIndex]?.name ?? '';
    }
    return result;
  }

  change() {
    this.$emit('modProps', this.form);
  }

  resizedEvent(h, w) {
    const elements = this.pageData.elements[this.curEleIndex];
    console.log('resizedEvent', this.curEleIndex, elements);
    this.updatePageInfo({ containerIndex: this.curEleIndex, data: { ...elements, point: { ...elements.point, w: w ?? elements.point.w, h: h ?? elements.point.h } } });
  }

  getStyle(oElement, sName) {
    const result = oElement.currentStyle ? oElement.currentStyle[sName] : getComputedStyle(oElement, null)[sName];
    return result.includes('px') ? result.slice(0, -2) : result;
  }

  changeAlignType(type) {
    const freedomBody = document.querySelector('.freedom-body');
    const curElement = (freedomBody as Element).children[this.curChildIndex];
    const [ containerW, containerH ] = [this.getStyle(freedomBody, 'width'), this.getStyle(freedomBody, 'height')];
    const [ eleW, eleH ] = [this.getStyle(curElement, 'width'), this.getStyle(curElement, 'height')];
    const elements = this.pageData.elements[this.curEleIndex].child[this.curChildIndex];
    let { left, top } = elements.commonStyle;
    switch (type) {
    case 'top':
      top = 0; break;
    case 'right':
      left = subtract(containerW, eleW); break;
    case 'bottom':
      top = subtract(containerH, eleH); break;
    case 'left':
      left = 0; break;
    case 'vertical':
      top = ceil(divide(subtract(containerH, eleH), 2), 2); break;
    case 'horizontal':
      left = ceil(divide(subtract(containerW, eleW), 2), 2); break;
    default: break;
    }
    this.updatePageInfo({ containerIndex: this.curEleIndex, childIndex: this.curChildIndex, data: { ...elements, commonStyle: { ...elements.commonStyle, left, top } } });
  }
}