import { Context, Service } from 'egg';

export default class RecordsService extends Service {
  private context: Context;
  constructor(ctx: Context) {
    super(ctx);
    this.context = ctx;
  }
  async clearInvalidPageHistoryRecords() {
    // 操作记录表直接删除半年以上的操作记录
    const limitDate = new Date(new Date().getTime() - 180 * 24 * 3600 * 1000).toLocaleDateString().replace(/\//g, '-')
    try {
      this.context.logger.info(`开始删除页面历史记录，删除范围为日期在${limitDate}之前的所有记录`);
      await this.context.model.PageHistory.destroy({
        where: {
          updated_at: {
            $lte: new Date(limitDate)
          }
        }
      });
      this.context.logger.info(`页面历史记录删除成功，删除范围为日期在${limitDate}之前的所有记录`);
    } catch (err) {
      this.context.logger.info(`页面历史记录删除失败，失败原因: ${JSON.stringify(err)}`);
    }
    return;
  }
}
