import { Component, Vue, Prop, Watch } from 'vue-property-decorator';
import FreedomContainer from '../../component/FreedomContainer/index.vue';
import { kebabCase, chunk, flatten } from 'lodash';
import { State } from 'vuex-class';
import { v4 as uuid } from 'uuid';

@Component({ name: 'DynamicComponent' })
export default class DynamicComponent extends Vue {
  @State(state => state.editor.gridLayout.colNum) colNum;
  @Prop({ default: () => ([]), type: Array }) data;

  eleConfig: array = [];

  @Watch('data', { immediate: true })
  onDataChange(newVal) {
    this.eleConfig = chunk(newVal, 2);
  }

  dragstart(event, eleName) {
    this.$emit('dragstart');
    const eleConfig = flatten(this.eleConfig).find(config => config.eleName === eleName);
    const id = uuid().slice(19);
    const compontObj = {
      id,
      name: eleName,
      title: eleConfig.title,
      point: {x: 0, y: 0, w: this.colNum, h: 300, i: id},
      schame: eleConfig.config,
      props: {...eleConfig.value},
      commonStyle: eleConfig.commonStyle
    };
    // const props = this.getProps(eleName);
    if (eleName.includes('template')) {
      event.dataTransfer.setData('text', JSON.stringify({
        template: eleConfig.page
      }));
    // 自由容器和商品导航组件有child属性
    } else if (eleName === 'freedom-container' || eleName === 'goods-tabs') {
      event.dataTransfer.setData('text', JSON.stringify({ ...compontObj, child: [] }));
    } else {
      event.dataTransfer.setData('text', JSON.stringify(compontObj));
    }
    event.dataTransfer.effectAllowed = 'copyMove';
  }

  dragend() {
    this.$emit('dragend');
    console.log('dragend');
  }

  // getProps(eleName) {
  //   const props = {};
  //   for (const key of Object.keys(components)) {
  //     const component = components[key];
  //     if (kebabCase(component.name) === eleName && component.props) {
  //       for (const prop of Object.keys(component.props)) {
  //         props[prop] = ['Object', 'Array'].includes(component.props[prop].type.name) ? component.props[prop].default && component.props[prop].default() : component.props[prop].default;
  //       }
  //     }
  //   }

  //   return props;
  // }
}