import http from '../service/http.service';
import config from '../config';
import axios from 'axios';

export default {
  getPageList(params) {
    return http.get('editor/get/list', { params });
  },
  refreshCache() {
    return http.post('editor/clearcache');
  },
  getPageById(params) {
    return http.get(`editor/get/${params.pageId}?isEditor=1`);
  },
  delPageById(pageId) {
    return http.delete(`editor/${pageId}`);
  },
  updatePage(params) {
    return http.post(`editor/update`, params);
  },
  savePage(params) {
    return http.post(`editor/save`, params);
  },
  getTemplateList() {
    return http.get('editor/get/template');
  },
  getUpToken() {
    return axios.get(`${config.opapiHost}/upload/getToken`);
  },
  uploadBase64(base64Str, name, token) {
    return axios.post(`${config.qiniuUpHost}/putb64/-1/key/${name}`, base64Str, {
      headers: {
        'content-type': 'application/octet-stream',
        'Authorization': token,
      }
    });
  }
};