import { Component, Vue, Prop, Watch, Emit, Mixins } from 'vue-property-decorator';
import { Getter, Action, State, Mutation } from 'vuex-class';
import type { PageInfo, Page, GridLayout  } from '@store/modules/editor/state';
import TransformStyleMixin from '@page/mixins/transformStyle.mixin';
import FreedomContainer from '@editor/component/FreedomContainer/index.vue';

@Component({ components: { FreedomContainer }, name: 'OperationPanel' })
export default class OperationPanel extends Mixins(TransformStyleMixin) {
  @Getter('pageData') pageData;
  @State(state => state.editor.gridLayout) gridLayout?: GridLayout;
  @State(state => state.editor.curEleIndex) curEleIndex!: number | null;
  @State(state => state.editor.curChildIndex) curChildIndex!: number | null;

  @Prop(Boolean) isDraging;
  @Prop(Boolean) isDragIn;

  get layout() {
    return this.pageData.elements.map(v => v.point);
  }

  @Emit('update:isDragIn')
  dragenter() {
    return true;
  }

  @Emit('update:isDragIn')
  dragleave() {
    return false;
  }

  @Emit('dragover')
  dragover(event) {
    //
  }

  @Emit('drops')
  drops(event) {
    //
  }

  @Emit('handleElementClick')
  handleElementClick(curEleIndex?: number | null, curChildIndex?: number | null) {
    //
  }

  @Emit('show')
  show(event, containerIndex, childIndex) {
    //
  }

  @Emit('resizedEvent')
  resizedEvent(i, h, w) {
    //
  }

  @Emit('movedEvent')
  movedEvent(i, newX, newY) {
    //
  }

  @Emit('toggle')
  toggle(val) {
    //
  }
}