import Http from '@/service/http.service.ts';
import Cookies from '@/service/cookieStorage.service.ts';
import localStorage from '@/service/localStorage.service.ts';
import qs from 'qs';

// const ApiBaseUrl = 'http://passportapi.q-gp.com';
const ApiBaseUrl = 'https://passportapi-fe.liangkebang.net';

export default {
  getCaptcha() {
    return Http.post(ApiBaseUrl + '/api/captcha');
  },
  sendVcode(phone, captcha, captchaId) {
    const params = {
      phoneNo: phone,
      captchaId,
      captchaValue: captcha,
    };
    return Http.post(ApiBaseUrl + '/api/sms/send_login_code_new_forH5', qs.stringify(params));
  },
  sendGtVcode(gt) {
    return Http.post(ApiBaseUrl + '/api/sms/send_login_code_new_forH5', qs.stringify(gt));
  },
  fastLogin(phone, vcode, clickId, uniqueKey, registerFrom = 1) {
    const headers = {
      Authorization: 'Verification ' + btoa(phone + ':' + vcode),
    };

    const params = {
      channelId: 1,
      createdFrom: registerFrom,
      key: 'xyqb',
      btRegisterChannelId: '',
      dimension: '',
      click_id: clickId,
      uniqueKey,
    };
    return Http.post(ApiBaseUrl + '/user/login/fastV1', qs.stringify(params), {
      headers,
    });
  },
  // 判断极验还是qg
  verifyMode(clientType, phoneNo) {
    return Http.post(ApiBaseUrl + '/api/captcha/new', { clientType, phoneNo });
  },
  goNext(params) {
    return Http.post(ApiBaseUrl + '/platform/api/page/next', qs.stringify(params));
  }
};
