// export const basicComponents = require('@qg/cherry-ui/md/index.json');
export const kaLoginForm = require('@qg/citrus-ui/md/index.json');

export const basicComponents = [
  {
    eleName: 'freedom-container',
    title: '自由容器',
    h: 300,
    config: [
      {
        key: 'backgroundImage',
        name: '背景图片',
        type: 'Upload'
      },
    ],
    value: {
      backgroundImage: 'http://activitystatic.q-gp.com/landing-bg.png';
    },
    commonStyle: {}
  },
  {
    h: 44,
    eleName: 'cr-button',
    title: 'Button 按钮',
    config: [
      {
        key: 'type',
        name: '类型',
        desc: '类型，可选值为',
        options: [
          'default',
          'primary',
          'info',
          'danger',
          'waring',
          'success'
        ],
        type: 'select'
      },
      {
        key: 'size',
        name: '尺寸',
        desc: '尺寸，可选值为',
        options: [
          'normal',
          'large',
          'small',
          'mini'
        ],
        type: 'select'
      },
      {
        key: 'color',
        name: '颜色',
        desc: '按钮颜色，支持传入',
        type: 'ColorSelector'
      },
      {
        key: 'icon',
        name: '图标',
        desc: '左侧',
        type: 'text'
      },
      {
        key: 'block',
        name: '块级元素',
        desc: '是否为块级元素',
        type: 'checkbox'
      },
      {
        key: 'shape',
        name: '形状',
        desc: '按钮形状，可选值为',
        options: [
          'square',
          'circle'
        ],
        type: 'select'
      },
      {
        key: 'disabled',
        name: '禁用',
        desc: '是否禁用按钮',
        type: 'checkbox'
      },
      {
        key: 'plain',
        name: '朴素按钮',
        desc: '朴素按钮',
        type: 'checkbox'
      },
      {
        key: 'hairline',
        name: '细边框',
        desc: '细边框',
        type: 'checkbox'
      },
      {
        key: 'loading',
        name: '加载中',
        desc: '是否显示为加载状态',
        type: 'checkbox'
      },
      {
        key: 'loadingText',
        name: '加载文字',
        desc: '加载状态提示文字',
        type: 'text'
      },
      {
        key: 'loadingType',
        name: '加载图标类型',
        desc: '',
        options: [
          'circular',
          'spinner'
        ],
        type: 'select'
      },
      {
        key: 'loadingSize',
        name: '加载图标大小',
        desc: '加载图标大小',
        type: 'text'
      }
    ],
    value: {
      type: 'default',
      size: 'normal',
      color: '',
      icon: '',
      block: false,
      shape: 'square',
      disabled: false,
      plain: false,
      hairline: false,
      loading: false,
      loadingText: '',
      loadingType: 'circular',
      loadingSize: '20px'
    },
    commonStyle: {}
  },
  {
    eleName: 'cr-image',
    title: '图片',
    h: 140,
    config: [
      {
        key: 'width',
        name: '宽度',
        type: 'text'
      },
      {
        key: 'height',
        name: '高度',
        type: 'text'
      },
      {
        key: 'src',
        name: '图片',
        type: 'Upload'
      },
    ],
    value: {
      width: '5.067rem',
      height: '3.733rem',
      src: 'https://appsync.lkbang.net/Fs0qmUsMry39AjHDf_W-qgn8XEy6',
      fit: 'contain',
    },
    commonStyle: {}
  },
  {
    eleName: 'cr-nav-bar',
    title: 'NavBar 导航栏',
    h: 48,
    config: [
      {
        key: 'title',
        name: '标题',
        desc: '标题',
        propType: 'string',
        options: [],
        type: 'text'
      },
      {
        key: 'leftText',
        name: '左侧文案',
        desc: '左侧文案',
        propType: 'string',
        options: [],
        type: 'text'
      },
      {
        key: 'rightText',
        name: '右侧文案',
        desc: '右侧文案',
        default: '',
        options: [
          'info',
          'danger',
          'primary',
          'warning'
        ],
        type: 'text'
      },
      {
        key: 'leftArrow',
        name: '左侧箭头',
        desc: '是否显示左侧箭头',
        propType: 'boolean',
        options: [],
        type: 'checkbox'
      },
      {
        key: 'border',
        name: '边框',
        desc: '是否显示下边框',
        propType: 'boolean',
        options: [],
        type: 'checkbox'
      },
      {
        key: 'fixed',
        name: '固定导航栏',
        desc: '是否固定导航栏',
        propType: 'boolean',
        options: [],
        type: 'checkbox'
      },
      {
        key: 'zIndex',
        name: 'z-index',
        desc: '元素z-index',
        propType: [
          'number',
          'string'
        ],
        options: [],
        type: 'text'
      }
    ],
    value: {
      title: '',
      leftText: '返回',
      rightText: '',
      leftArrow: true,
      border: true,
      fixed: true,
      zIndex: '9999'
    },
    commonStyle: {}
  }
];

export const businessComponents = [
  {
    eleName: 'login-form',
    title: 'KA登陆表单',
    h: 224,
    config: [
      {
        key: 'btnTxt',
        name: '按钮文案',
        type: 'text'
      },
      {
        key: 'btnColor',
        name: '按钮颜色',
        type: 'ColorSelector'
      },
      {
        key: 'btnImage',
        name: '按钮图片',
        type: 'Upload'
      },
      {
        key: 'vcBgColor',
        name: '验证码背景色(可点击态)',
        type: 'ColorSelector'
      },
      {
        key: 'registerFrom',
        name: '渠道号',
        type: 'text'
      },
    ],
    value: {
      btnTxt: '',
      btnColor: '#ee0a24',
      btnImage: 'http://activitystatic.q-gp.com/landing-submit.png',
      registerFrom: '',
      vcBgColor: '#97d5ff'
    },
    commonStyle: {}
  },
  {
    eleName: 'download-guide',
    title: '下载引导',
    h: 40,
    config: [
      {
        key: 'href',
        name: '跳转链接',
        type: 'text'
      },
      {
        key: 'leftImg',
        name: 'logo',
        type: 'Upload'
      }
    ],
    value: {
      href: 'https://s.xyqb.com/4',
      leftImg: 'http://activitystatic.q-gp.com/xyqb%402x.png'
    },
    commonStyle: {}
  }
];
