import {Component, Prop, Watch, Vue} from 'vue-property-decorator';
import TableModal from '../TableModal/index.vue';
import goodsColumn from './columns/goods.column';
import goodsSpecialColumn from './columns/goodsSpecial.column';
import goodsLabelColumn from './columns/goodsLabel.column';
import { cloneDeep } from 'lodash';
import operationApi from '@api/operation.api';

@Component({ components: { TableModal }, name: 'GoodsTableModal' })
export default class GoodsTableModal extends Vue {
  @Prop({ default: () => ({
    type: 'goods',
    ids: []
  }), type: Object }) value;
  @Prop({ default: () => ([]), type: Array }) formControl;

  templates: object = {};
  goods: object = cloneDeep(this.value);
  table: object[] = [
    {
      title: $t('select.product'),
      type: 'goods',
      key: 'skuNo',
      multiple: true,
      columns: goodsColumn.call(this),
      query: this.query
    },
    {
      title: $t('select.product.tag'),
      type: 'goodsLabel',
      key: 'id',
      multiple: false,
      columns: goodsLabelColumn.call(this),
      query: this.queryLabel
    },
    {
      title: $t('select.product.topic'),
      type: 'goodsGroup',
      key: 'id',
      multiple: false,
      columns: goodsSpecialColumn.call(this),
      query: this.querySpecial
    }
  ];

  @Watch('goods')
  onFormChange(newVal) {
    this.$emit('input', newVal);
  }

  async query(data) {
    const { records, total } = await operationApi.skuInfo({ type: 'list', ...data });
    const selections = this.templates?.ids ? this.templates.ids : this.goods.ids;
    console.log('query', selections, this.templates.ids);
    records?.forEach(record => {
      if (selections.some(v => v === record.skuNo)) {
        record._checked = true;
      }
    });
    return { data: records || [], total };
  },
  async getCategory() {
    function recursionData(data) {
      const list = [];
      data.forEach(item => {
        const { categoryId: id, categoryName: label, categoryLevel: level, children } = item;
        const itemData = { id, label, level };
        if (item.children && item.children.length) { itemData.children = recursionData(children); }
        list.push(itemData);
      });
      return list;
    }

    const res = await operationApi.categoryQuery();
    return recursionData(res.level1List || []);
  },
  async querySpecial(data) {
    const { records, total } = await operationApi.specialPage(data);
    const selections = this.templates?.ids ? this.templates.ids : this.goods.ids;
    console.log('query', selections, this.templates.ids);
    records?.forEach(record => {
      if (selections.some(v => v === record.id)) {
        record._checked = true;
      }
    });
    return { data: records || [], total };
  },
  async queryLabel(data) {
    const { records, total } = await operationApi.labelPage(data);
    const selections = this.templates?.ids ? this.templates.ids : this.goods.ids;
    console.log('query', selections, this.templates.ids);
    records?.forEach(record => {
      if (selections.some(v => v === record.id)) {
        record._checked = true;
      }
    });
    return { data: records || [], total };
  }
}