import { Component, Mixins, Prop, Watch } from 'vue-property-decorator';
import { Getter, State } from 'vuex-class';
import { reduce, ceil, subtract, divide, pick, cloneDeep, pickBy } from 'lodash';
import ContextMenuMixin from '@editor/mixins/contextMenu.mixin';
import DynamicFormMixin from './component/mixins/dynamicForm.mixin';
import Upload from './component/Upload/index.vue';
import ColorSelector from './component/ColorSelector/index.vue';
import DiscountGoodsSelector from './component/DiscountGoodsSelector/index.vue';
import SnapUpActivitySelector from './component/SnapUpActivitySelector/index.vue';
import SeckillSelector from './component/SeckillSelector/index.vue';
import VerticalAdStyleSelector from './component/VerticalAdStyleSelector/index.vue';
import CategoryTypeSelector from './component/CategoryTypeSelector/index.vue';
import CategorySelector from './component/CategorySelector/index.vue';
import BatchGoodsSelector from './component/BatchGoodsSelector/index.vue';
import SwiperStyleTypeSelector from './component/SwiperStyleTypeSelector/index.vue';
import SwiperListSelector from './component/SwiperListSelector/index.vue';
import GoodsSwiperSelector from './component/GoodsSwiperSelector/index.vue';
import DiscountGoodsSelectorV2 from './component/DiscountGoodsSelectorV2/index.vue';
import GoodsChannelTypeSelector from './component/GoodsChannelTypeSelector/index.vue';
import GoodsPromotionTypeSelector from './component/GoodsPromotionTypeSelector/index.vue';
import GoodsResourceSelector from './component/GoodsResourceSelector/index.vue';
import GoodsCubeSelector from './component/GoodsCubeSelector/index.vue';
import BaseSelect from './component/BaseSelect/index.vue';
import ComponentSelect from './component/ComponentSelect/index.vue';
import FormList from './component/FormList/index.vue';
import GoodsTableModal from './component/GoodsTableModal/index.vue';
import CouponTableModal from './component/CouponTableModal/index.vue';
import Textarea from './component/Textarea/index.vue';
import Number from './component/Number/index.vue';
import ColumnSelector from './component/ColumnSelector/index.vue';
import FontWeightSelector from './component/FontWeightSelector/index.vue';
import { resizeDiv, getStyle } from '@/service/utils.service';
import { getAllScheme } from '../../../store/modules/editor/scheme';
import EventBus from '@service/eventBus.service';

const allComponentsMap = getAllScheme();
@Component({ components: {
  Upload,
  ColorSelector,
  BaseSelect,
  FormList,
  Textarea,
  Number,
  ComponentSelect,
  GoodsTableModal,
  CouponTableModal,
  ColumnSelector,
  DiscountGoodsSelector,
  SnapUpActivitySelector,
  CategoryTypeSelector,
  CategorySelector,
  VerticalAdStyleSelector,
  BatchGoodsSelector,
  DiscountGoodsSelectorV2,
  SwiperStyleTypeSelector,
  SwiperListSelector,
  GoodsSwiperSelector,
  GoodsChannelTypeSelector,
  GoodsPromotionTypeSelector,
  FontWeightSelector,
  GoodsResourceSelector,
  GoodsCubeSelector,
  SeckillSelector
}, name: 'DynamicForm' })
export default class DynamicForm extends Mixins(ContextMenuMixin, DynamicFormMixin) {
  @State(state => state.editor.curEleIndex) curEleIndex;
  @State(state => state.editor.curChildIndex) curChildIndex;
  @Getter('pageData') pageData;

  prevCommonStyle: object = {
    paddingTop: 0, paddingBottom: 0, paddingLeft: 0, paddingRight: 0
  };
  form: object = {};
  currentSchame: object[] = [];
  styleSchame: object = {
    curEle: [
      {
        label: $t('position'),
        list: [
          {
            content: $t('top.align'),
            icon: 'arrow-up-c',
            args: 'top'
          },
          {
            content: $t('right.align'),
            icon: 'arrow-right-c',
            args: 'right'
          },
          {
            content: $t('bottom.align'),
            icon: 'arrow-down-c',
            args: 'bottom'
          },
          {
            content: $t('left.align'),
            icon: 'arrow-left-c',
            args: 'left'
          },
          {
            content: $t('vertical.center'),
            icon: 'android-film',
            args: 'vertical'
          },
          {
            content: $t('horizontal.center'),
            icon: 'android-film',
            args: 'horizontal'
          },
        ]
      },
      {
        label: $t('position')
      },
      {
        label: $t('size'),
        list: [
          {
            content: $t('fullscreen'),
            icon: 'arrow-resize',
            args: 'full'
          },
          {
            content: $t('100.width'),
            icon: 'arrow-swap',
            args: 'width'
          },
          {
            content: $t('height.100'),
            icon: 'arrow-swap',
            args: 'height'
          },
        ]
      },
      {
        label: $t('dimensions')
      },
      {
        label: $t('background.image')
      },
      {
        label: $t('background.color')
      }
    ],
    curChild: [
      {
        label: $t('container.dimensions'),
        list: [
          {
            content: $t('fullscreen'),
            icon: 'arrow-resize',
            args: [667, 375],
          },
          {
            content: $t('autosize.by.background'),
            icon: 'image',
            args: [667, 375, 'image'],
          },
          {
            content: $t('autosize.by.element'),
            icon: 'stop',
            args: ['', '', 'element'],
          },
          {
            content: $t('100.width'),
            icon: 'arrow-swap',
            args: [null, 375]
          },
          {
            content: $t('height.100'),
            icon: 'arrow-swap',
            args: [667, null]
          }
        ]
      },
      {
        label: $t('container.size')
      },
      {
        label: $t('background.image')
      },
      {
        label: $t('background.color')
      },
      {
        label: $t('top.margin'),
        key: 'paddingTop'
      },
      {
        label: $t('bottom.margin'),
        key: 'paddingBottom'
      },
      {
        label: $t('left.margin'),
        key: 'paddingLeft'
      },
      {
        label: $t('right.margin'),
        key: 'paddingRight'
      },
    ]
  };

  get curElement() {
    return this.getCurElement();
  }

  get point() {
    return this.curEleIndex || this.curEleIndex === 0 ? cloneDeep(this.pageData.elements[this.curEleIndex]?.point) : { h: 0, w: 0 };
  }

  get commonStyle() {
    let rs = { backgroundColor: '', backgroundImage: '', paddingTop: 0, paddingBottom: 0, paddingLeft: 0, paddingRight: 0 };
    if (this.curEleIndex || this.curEleIndex === 0) {
      if (this.curChildIndex || this.curChildIndex === 0) {
        rs = cloneDeep({ ...rs, ...this.pageData.elements[this.curEleIndex].child[this.curChildIndex].commonStyle });
      } else {
        rs = cloneDeep({ ...rs, ...this.pageData.elements[this.curEleIndex].commonStyle });
      }
    }
    // console.log('commonStyle', rs);
    return rs;
  }

  get hasGroup() {
    return this.currentSchame.schame?.some(v => v.title);
  }

  get curFormKey() {
    const keys = [];
    this.currentSchame?.forEach(schame => {
      if (schame.children) {
        schame.children.forEach(child => {
          keys.push(child.key);
        });
      } else {
        keys.push(schame.key);
      }
    });
    return keys;
  }

  get eleName() {
    let result = '';
    if (!this.curChildIndex && this.curChildIndex !== 0) {
      result = this.pageData?.elements[this.curEleIndex]?.name ?? '';
    }
    return result;
  }

  get isSelected() {
    return this.curChildIndex || this.curChildIndex === 0 || this.curEleIndex || this.curEleIndex === 0;
  }

  get childSelected() {
    return this.curChildIndex || this.curChildIndex === 0;
  }

  get parentSelected() {
    return (this.curEleIndex || this.curEleIndex === 0) && !this.curChildIndex && this.curChildIndex !== 0;
  }

  @Watch('curEleIndex', { immediate: true })
  onCurEleIndexChange(newVal) {
    this.setForm(newVal, 'curEleIndex');
  }

  @Watch('curChildIndex', { immediate: true })
  onCurChildIndexChange(newVal) {
    this.setForm(newVal, 'curChildIndex');
  }

  getCurElement() {
    let element = {};
    if (this.curEleIndex !== null) {
      if (this.curChildIndex !== null && this.pageData.elements[this.curEleIndex]) {
        element = this.pageData.elements[this.curEleIndex].child[this.curChildIndex];
      } else {
        element = this.pageData.elements[this.curEleIndex];
      }
    }
    this.currentSchame = allComponentsMap[element.name] || [];
    return element;
  }

  setForm(newVal, type) {
    this.form = { id: `${type}${newVal}` };
    const element = this.getCurElement();
    this.currentSchame?.forEach(schame => {
      if (schame.children) {
        schame.children.forEach(child => {
          this.$set(this.form, child.key, element.props[child.key]);
        });
      } else {
        this.$set(this.form, schame.key, element.props[schame.key]);
      }
    });
    // console.log('setForm', this.form);
  }

  // 监听form变化, 更新pageData
  @Watch('form', { immediate: true, deep: true })
  onFormChange(newVal, oldVal) {
    // console.log('onFormChange', newVal?.id, oldVal?.id);
    if (newVal?.id !== oldVal?.id) { return; }
    const params = pick(this.form, this.curFormKey);
    this.$nextTick(() => {
      const element = this.pageData.elements[this.curEleIndex];
      // swiper refresh 后会自动调整
      if (element.name !== 'cs-guide-cube') {
        this.adjustHeight();
      }
      if (element.name === 'freedom-container') {
        const { isFinance } = newVal;
        if (isFinance) {
          newVal.needLogin = true;
          newVal.disabledSelectNeedLogin = true;
        } else {
          newVal.disabledSelectNeedLogin = false;
        }
      }
    });
    this.$emit('modProps', params, 'component');
  }

  updatePoint(value, key) {
    // console.log('updatePoint', this.point);
    const elements = this.pageData.elements[this.curEleIndex];
    this.updatePageInfo({ containerIndex: this.curEleIndex, data: { ...elements, point: { ...elements.point, ...this.point  } } });
  }

  updateStyle(value, key) {
    // console.log('updateCommonStyle', this.commonStyle);
    const elements = this.pageData.elements[this.curEleIndex];
    // this.updatePageInfo({ containerIndex: this.curEleIndex, data: { ...elements, commonStyle: { ...elements.commonStyle, ...this.commonStyle  } } });
    this.updateCommonStyle({ containerIndex: this.curEleIndex, childIndex: this.curChildIndex, data: this.commonStyle });
  }

  getDataFromProps() {
    if (this.curEleIndex || this.curEleIndex === 0) {
      this.point = this.pageData.elements[this.curEleIndex]?.point || this.point;
      this.commonStyle = Object.assign({}, initialCommonStyle, this.pageData.elements[this.curEleIndex].commonStyle);
      if (this.curChildIndex || this.curChildIndex === 0) {
        this.commonStyle = Object.assign({}, this.pageData.elements[this.curEleIndex].child[this.curChildIndex].commonStyle);
      }
    }
  }

  resizedEvent(h, w, responsive) {
    const elements = this.pageData.elements[this.curEleIndex];
    if (responsive) {
      if (responsive === 'image' && elements.commonStyle.backgroundImage) {
        // if (elements.name === 'freedom-container') {
        resizeDiv(elements.commonStyle.backgroundImage, 667, 375, (imgHeight) => {
          this.updatePageInfo({ containerIndex: this.curEleIndex, data: { ...elements, point: { ...elements.point, w: w ?? elements.point.w, h: imgHeight ?? elements.point.h, responsive: true } } });
        });
        // }
      } else if (responsive === 'element' && elements.id) {
        this.adjustHeight();
      }
    } else {
      this.updatePageInfo({ containerIndex: this.curEleIndex, data: { ...elements, point: { ...elements.point, w: w ?? elements.point.w, h: h ?? elements.point.h } } });
    }
  }

  changeAlignType(type) {
    const freedomBody = document.querySelector('.freedom-body');
    const curElement = (freedomBody as Element).children[this.curChildIndex];
    const [ containerW, containerH ] = [getStyle(freedomBody, 'width'), getStyle(freedomBody, 'height')];
    const [ eleW, eleH ] = [getStyle(curElement, 'width'), getStyle(curElement, 'height')];
    const elements = this.pageData.elements[this.curEleIndex].child[this.curChildIndex];
    let { left, top } = elements.commonStyle;
    switch (type) {
    case 'top':
      top = 0; break;
    case 'right':
      left = subtract(containerW, eleW); break;
    case 'bottom':
      top = subtract(containerH, eleH); break;
    case 'left':
      left = 0; break;
    case 'vertical':
      top = ceil(divide(subtract(containerH, eleH), 2), 2); break;
    case 'horizontal':
      left = ceil(divide(subtract(containerW, eleW), 2), 2); break;
    case 'full': case 'width': case 'height':
      EventBus.$emit('resizedChildEvent', type); break;
    default: break;
    }
    this.updatePageInfo({ containerIndex: this.curEleIndex, childIndex: this.curChildIndex, data: { ...elements, commonStyle: { ...elements.commonStyle, left, top } } });
  }

  changeMargin() {
    const ele = this.getCurElement();
    const prevCommonStyle = cloneDeep(ele.commonStyle || {});
    // this.point.w = this.point.w - (this.commonStyle.paddingLeft || 0) - (this.commonStyle.paddingRight || 0);
    this.point.h = this.point.h - (prevCommonStyle.paddingTop || 0) - (prevCommonStyle.paddingBottom || 0) + (this.commonStyle.paddingTop || 0) + (this.commonStyle.paddingBottom || 0);
    this.updateCommonStyle({ containerIndex: this.curEleIndex, childIndex: this.curChildIndex, data: this.commonStyle });
    this.updatePoint();
    this.adjustHeight();
  }
}
